% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.aln.R
\name{community.aln}
\alias{community.aln}
\title{Align communities from two or more networks}
\usage{
community.aln(x, ...)
}
\arguments{
\item{x, ...}{two or more objects of class \code{cna} (with equal number of
nodes) as obtained from function \code{\link{cna}}. Alternatively, a list 
of \code{cna} objects can be given to \code{x}, the element of which will 
be used for pairwise comparison.}
}
\value{
Returns a list of updated \code{cna} objects.
}
\description{
Find equivalent communities from two or more networks and renumber them in
a consistent way across networks.
}
\details{
This function facilitates the inspection on the variance of the community
partition in a group of similar networks. The original community numbering
(and so coloring in \code{plot.cna}) can be inconsistent across networks, 
i.e. equivalent communities may have different numbering in different 
networks. The function calculates the dissimilarity between all communities 
and clusters communities with \sQuote{hclust} funciton. In each cluster, 0 or
1 community per network is included. Communities are then renumbered 
according to the clusters through all networks. Note that the 
\sQuote{membership} in \code{$communities} is not updated because some basic
\sQuote{igraph} functions such as \code{length} assume the \sQuote{membership} 
a consecutive integer vector. Instead, a \sQuote{renumbered} membership 
vector is added as an extra component in the returned \sQuote{cna} object.
}
\examples{
\donttest{
  # Needs MUSCLE installed - testing excluded
  if(check.utility("muscle")) {

    ## Fetch PDB files and split to chain A only PDB files
    ids <- c("1tnd_A", "1tag_A")
    files <- get.pdb(ids, split = TRUE, path = tempdir())
    
    ## Sequence Alignement
    pdbs <- pdbaln(files, outfile = tempfile())
    
    ## Normal mode analysis on aligned data
    modes <- nma(pdbs, rm.gaps=TRUE)
    
    ## Dynamic Cross Correlation Matrix
    cijs <- dccm(modes)$all.dccm
 
    ## Correlation Network
    nets <- cna(cijs, cutoff.cij=0.3)

    ## Align network communities
    nets.aln <- community.aln(nets)

    ## plot all-residue and coarse-grained (community) networks
    pdb <- pdbs2pdb(pdbs, inds=1, rm.gaps=TRUE)[[1]]
    op <- par(no.readonly=TRUE)

    # before alignment
    par(mar=c(0.1, 0.1, 0.1, 0.1), mfrow=c(2,2))
    invisible( lapply(nets, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3, full=TRUE)[, 1:2], 
               full=TRUE)) )
    invisible( lapply(nets, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3)[, 1:2])) )

    # after alignment
    par(mar=c(0.1, 0.1, 0.1, 0.1), mfrow=c(2,2))
    invisible( lapply(nets.aln, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3, full=TRUE)[, 1:2], 
               full=TRUE)) )
    invisible( lapply(nets.aln, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3)[, 1:2])) )

    par(op)     
  }
}
}
\seealso{
\code{\link{cna}}, \code{\link{plot.cna}}
}
\keyword{analysis}

