% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-methods-r-sq-beta-sandwich.R
\name{confint.rsqbetasandwich}
\alias{confint.rsqbetasandwich}
\title{Confidence Intervals for
Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)}
\usage{
\method{confint}{rsqbetasandwich}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{rsqbetasandwich}.}

\item{parm}{a specification of which parameters
are to be given confidence intervals,
either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Confidence Intervals for
Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
rsq <- RSqBetaSandwich(std)
confint(rsq, level = 0.95)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
