% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gives_beast2_warning.R
\name{gives_beast2_warning}
\alias{gives_beast2_warning}
\title{Determines if BEAST2 issues a warning
when using the BEAST2 XML input file}
\usage{
gives_beast2_warning(
  filename,
  verbose = FALSE,
  beast2_path = beastier::get_default_beast2_path()
)
}
\arguments{
\item{filename}{name of the BEAST2 XML input file}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}

\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
TRUE if the file produces a BEAST2 warning, FALSE if not
}
\description{
Determines if BEAST2 issues a warning
when using the BEAST2 XML input file
}
\examples{
if (is_beast2_installed() &&
  is_on_ci() &&
  rappdirs::app_dir()$os == "unix") {

  # This file is OK for BEAST2, no warning, returns FALSE
  gives_beast2_warning(filename = get_beastier_path("2_4.xml"))

  # BEAST2 will give a warning on this file, returns TRUE
  gives_beast2_warning(
    filename = get_beastier_path("beast2_warning.xml")
  )
}
}
\seealso{
Use \code{\link{is_beast2_input_file}} to check if a file is a
  valid BEAST2 input file.
  Use \code{\link{are_beast2_input_lines}} to check if the text (for
  example, as loaded from a file) to be valid BEAST2 input.
}
\author{
Richèl J.C. Bilderbeek
}
