% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdsvd.R
\name{bdsvd.ht}
\alias{bdsvd.ht}
\title{Hyperparameter Tuning for BD-SVD}
\usage{
bdsvd.ht(X, dof.lim, standardize = TRUE, max.iter)
}
\arguments{
\item{X}{Data matrix of dimension \eqn{n x p} with possibly \eqn{p >> n}.}

\item{dof.lim}{Interval limits for the number of non-zero components in the sparse loading (degrees of freedom).
If \eqn{S} denotes the support of \eqn{v}, then the cardinality of the support, \eqn{|S|},
corresponds to the degrees of freedom. Default is \code{dof.lim <- c(0, p-1)} which is highly recommended to check for
all levels of sparsity.}

\item{standardize}{Standardize the data to have unit variance. Default is \code{TRUE}.}

\item{max.iter}{How many iterations should be performed for computing the sparse loading.
Default is \code{200}.}
}
\value{
\item{dof}{
The optimal number of nonzero components (degrees of freedom) according to the HBIC.
}
\item{BIC}{
The HBIC for the different numbers of nonzero components.
}
}
\description{
Finds the number of non-zero elements of the sparse loading according to the high-dimensional
Bayesian information criterion (HBIC).
}
\details{
The sparse loadings are computed using the method by Shen & Huang (2008), implemented in
the \code{irlba} package. The computation of the HBIC is outlined in Bauer (202Xa).
}
\examples{
#Replicate the illustrative example from Bauer (202Xa) with different values for p:

p <- 300 #Number of variables (p <- 3000 in Bauer (202Xa))
n <- 500 #Number of observations
b <- 3   #Number of blocks
design <- "c"

#Simulate data matrix X
set.seed(1)
Sigma <- bdsvd.cov.sim(p = p, b = b, design = design)
X <- mvtnorm::rmvnorm(n, mean = rep(0, p), sigma = Sigma)
colnames(X) <- 1:p

ht <- bdsvd.ht(X)
plot(0:(p-1), ht$BIC[,1], xlab = "|S|", ylab = "HBIC", main = "", type = "l")
single.bdsvd(X, dof = ht$dof, standardize = FALSE)

}
\references{
\cite{Bauer, J.O. (202Xa). High-dimensional block diagonal covariance structure detection using singular vectors.}

\cite{Shen, H. and Huang, J.Z. (2008). Sparse principal component analysis via regularized low rank matrix approximation, J. Multivar. Anal. 99, 1015–1034.}
}
\seealso{
\link{bdsvd}, \link{single.bdsvd}
}
