% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM_matrices.R
\name{SEM_sigma_matrix}
\alias{SEM_sigma_matrix}
\title{Covariance matrix for SEM representation}
\usage{
SEM_sigma_matrix(err_var, dep_vars, phis = c(), psis = c())
}
\arguments{
\item{err_var}{numeric}

\item{dep_vars}{numeric vector}

\item{phis}{numeric vector}

\item{psis}{numeric vector}
}
\value{
List with two matrices Sigma11 and Sigma12
}
\description{
Create covariance matrix for Simultaneous Equations Model (SEM)
representation. Only the part necessary to compute concentrated likelihood
function is computed (cf. Appendix in the Moral-Benito paper)
}
\examples{
err_var <- 1
dep_vars <- c(2, 2, 2, 2)
phis <- c(10, 10, 20, 20, 30, 30)
psis <- c(101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112)
SEM_sigma_matrix(err_var, dep_vars, phis, psis)
}
