% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindEmoticonPipe.R
\docType{class}
\name{FindEmoticonPipe}
\alias{FindEmoticonPipe}
\title{Class to find and/or remove the emoticons on the data field of an Instance}
\usage{
FindEmoticonPipe
}
\description{
This class is responsible of detecting the existing emoticons in the
\strong{data} field of each \code{\link{Instance}}. Identified emoticons are
stored inside the \strong{emoticon} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline emoticon removement.
}
\section{Constructor}{

\preformatted{
FindEmoticonPipe$new(propertyName = "emoticon",
                     alwaysBeforeDeps = list(),
                     notAfterDeps = list("FindHashtagPipe"))
}

\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Details}{

The regular expression indicated in the \code{emoticonPattern}
variable is used to identify emoticons.
}

\section{Note}{

\code{\link{FindEmoticonPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{PipeGeneric}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/remove the emoticons.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance, removeEmoticon = TRUE)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
\item{\strong{removeEmoticon:}}{
(\emph{logical}) indicates if the emoticons are replaced.
}
}
}
}
}

\item{\bold{findEmoticon:}}{
finds the emoticons in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findEmoticon(data)}
}
\item{\emph{Value:}}{
list with emoticons found.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to search the emoticons.
}
}
}
}
}

\item{\bold{removeEmoticon:}}{
removes the emoticons in the data.
\itemize{
\item{\emph{Usage:}}{
\code{removeEmoticon(data)}
}
\item{\emph{Value:}}{
the data with emoticons removed.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text in which emoticons will be removed.
}
}
}
}
}
}
}

\section{Public fields}{

\itemize{
\item{\bold{emoticonPattern:}}{
 (\emph{character}) regular expression to detect emoticons.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{PipeGeneric}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
