% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbknn.R
\name{RunBBKNN}
\alias{RunBBKNN}
\alias{RunBBKNN.default}
\alias{RunBBKNN.Seurat}
\title{Perform batch balanced KNN}
\usage{
RunBBKNN(object, ...)

\method{RunBBKNN}{default}(
  object,
  batch_list,
  n_pcs = 50L,
  neighbors_within_batch = 3L,
  trim = NULL,
  approx = TRUE,
  use_annoy = TRUE,
  annoy_n_trees = 10L,
  pynndescent_n_neighbors = 30L,
  pynndescent_random_state = 0L,
  use_faiss = TRUE,
  metric = "euclidean",
  set_op_mix_ratio = 1,
  local_connectivity = 1,
  seed = 42,
  verbose = TRUE,
  ...
)

\method{RunBBKNN}{Seurat}(
  object,
  batch_key,
  assay = NULL,
  reduction = "pca",
  n_pcs = 50L,
  graph_name = "bbknn",
  set_op_mix_ratio = 1,
  local_connectivity = 1,
  run_TSNE = TRUE,
  TSNE_name = "tsne",
  TSNE_key = "tSNE_",
  run_UMAP = TRUE,
  UMAP_name = "umap",
  UMAP_key = "UMAP_",
  min_dist = 0.3,
  spread = 1,
  seed = 42,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{batch_list}{A character vector with the same length as nrow(pca)}

\item{n_pcs}{Number of dimensions to use. Default is 50.}

\item{neighbors_within_batch}{How many top neighbours to report for each batch; 
total number of neighbours in the initial k-nearest-neighbours computation will 
be this number times the number of batches. This then serves as the basis for 
the construction of a symmetrical matrix of connectivities.}

\item{trim}{Trim the neighbours of each cell to these many top connectivities. 
May help with population independence and improve the tidiness of clustering. 
The lower the value the more independent the individual populations, at the 
cost of more conserved batch effect. Default is 10 times neighbors_within_batch 
times the number of batches. Set to 0 to skip.}

\item{approx}{If TRUE, use approximate neighbour finding - RcppAnnoy or pyNNDescent. 
This results in a quicker run time for large datasets while also potentially 
increasing the degree of batch correction.}

\item{use_annoy}{Only used when approx = TRUE. If TRUE, will use RcppAnnoy for 
neighbour finding. If FALSE, will use pyNNDescent instead.}

\item{annoy_n_trees}{Only used with annoy neighbour identification. The number of 
trees to construct in the annoy forest. More trees give higher precision when 
querying, at the cost of increased run time and resource intensity.}

\item{pynndescent_n_neighbors}{Only used with pyNNDescent neighbour identification. 
The number of neighbours to include in the approximate neighbour graph. More neighbours 
give higher precision when querying, at the cost of increased run time and resource 
intensity.}

\item{pynndescent_random_state}{Only used with pyNNDescent neighbour identification. 
The RNG seed to use when creating the graph.}

\item{use_faiss}{If approx = FALSE and the metric is "euclidean", use the faiss 
package to compute nearest neighbours if installed. This improves performance at 
a minor cost to numerical precision as faiss operates on float32.}

\item{metric}{What distance metric to use. The options depend on the choice of 
neighbour algorithm. "euclidean", the default, is always available.}

\item{set_op_mix_ratio}{Pass to 'set_op_mix_ratio' parameter for \code{\link[uwot]{umap}}}

\item{local_connectivity}{Pass to 'local_connectivity' parameter for \code{\link[uwot]{umap}}}

\item{seed}{Set a random seed. By default, sets the seed to 42. Setting NULL will 
not set a seed.}

\item{verbose}{Whether or not to print output to the console}

\item{batch_key}{Column name in meta.data discriminating between your batches.}

\item{assay}{used to construct Graph.}

\item{reduction}{Which dimensional reduction to use for the BBKNN input. 
Default is PCA}

\item{graph_name}{Name of the generated BBKNN graph. Default is bbknn.}

\item{run_TSNE}{Whether or not to run t-SNE based on BBKNN results.}

\item{TSNE_name}{Name to store t-SNE dimensional reduction.}

\item{TSNE_key}{Specifies the string before the number of the t-SNE dimension 
names. tSNE by default.}

\item{run_UMAP}{Whether or not to run UMAP based on BBKNN results.}

\item{UMAP_name}{Name to store UMAP dimensional reduction.}

\item{UMAP_key}{Specifies the string before the number of the UMAP dimension 
names. tSNE by default.}

\item{min_dist}{Pass to 'min_dist' parameter for \code{\link[uwot]{umap}}}

\item{spread}{Pass to 'spread' parameter for \code{\link[uwot]{umap}}}
}
\value{
Returns a Seurat object containing a new BBKNN Graph. If run t-SNE or UMAP, will 
also return corresponded reduction objects.
}
\description{
Batch balanced KNN, altering the KNN procedure to identify each cell’s top neighbours 
in each batch separately instead of the entire cell pool with no accounting for batch. 
The nearest neighbours for each batch are then merged to create a final list of neighbours 
for the cell. Aligns batches in a quick and lightweight manner.
}
\references{
Polański, Krzysztof, et al. "BBKNN: fast batch alignment of single cell 
transcriptomes." Bioinformatics 36.3 (2020): 964-965.
}
