% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateNHPP.R
\name{simulateNHPP}
\alias{simulateNHPP}
\title{Simulates event times from an inhomogenous Poisson process on [0,T]}
\usage{
simulateNHPP(targetfn, maxintensity, T = Inf)
}
\arguments{
\item{targetfn}{A first order function defining the process intensity}

\item{maxintensity}{The maximum values of targetfn}

\item{T}{Length of the interval [0,T] on which to simulate the process}
}
\value{
The simulated event times
}
\description{
Simulates event times from an inhomogenous Poisson process on [0,T]
}
\examples{
simulateNHPP(function(x) {sin(x)+1}, 2, 100)
simulateNHPP(function(x) {x^2}, 100, 10)
}
\author{
Gordon J Ross
}

