% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcPotts.R
\name{exactPotts}
\alias{exactPotts}
\title{Calculate the distribution of the Potts model using a brute force algorithm.}
\usage{
exactPotts(neighbors, blocks, k, beta)
}
\arguments{
\item{neighbors}{A matrix of all neighbors in the lattice, one row per pixel.}

\item{blocks}{A list of pixel indices, dividing the lattice into independent blocks.}

\item{k}{The number of unique labels.}

\item{beta}{The inverse temperature parameter of the Potts model.}
}
\value{
A list containing the following elements:
\describe{
  \item{\code{expectation}}{The exact mean of the sufficient statistic.}
  \item{\code{variance}}{The exact variance of the sufficient statistic.}
  \item{\code{exp_PL}}{Pseudo-likelihood (PL) approximation of the expectation of S(z).}
  \item{\code{var_PL}}{PL approx. of the variance of the sufficient statistic.}
  }
}
\description{
\bold{Warning}: this algorithm is O\eqn{(k^n)} and therefore will not scale for
\eqn{k^n > 2^{31} - 1}
}

