% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{waic_bgam}
\alias{waic_bgam}
\alias{waic_bgam,bayesGAMfit-method}
\alias{waic_bgam,array-method}
\title{Calls the \code{loo} package to calculate the widely applicable information criterion (WAIC)}
\usage{
waic_bgam(object, ...)

\S4method{waic_bgam}{bayesGAMfit}(object, ...)

\S4method{waic_bgam}{array}(object, ...)
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit} generated from \code{bayesGAM}.}

\item{...}{Additional parameters to pass to pass to \code{loo::waic}}
}
\value{
a named list of class \code{c("waic", "loo")}
\describe{
\item{\code{estimates}}{
A matrix with two columns (\code{"Estimate"}, \code{"SE"}) and three
rows (\code{"elpd_waic"}, \code{"p_waic"}, \code{"waic"}). This contains
point estimates and standard errors of the expected log pointwise predictive
density (\code{elpd_waic}), the effective number of parameters
(\code{p_waic}) and the information criterion \code{waic} (which is just
\code{-2 * elpd_waic}, i.e., converted to deviance scale).
}
\item{\code{pointwise}}{
A matrix with three columns (and number of rows equal to the number of
observations) containing the pointwise contributions of each of the above
measures (\code{elpd_waic}, \code{p_waic}, \code{waic}).
}
}
}
\description{
Computes WAIC by calling the appropriate function from the \code{loo} package
}
\examples{
f <- bayesGAM(weight ~ np(height), data = women,
              family = gaussian, iter=500, chains = 1)
waic_bgam(f)
}
\references{
Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation and widely application information criterion in singular learning theory. Journal of Machine Learning Research 11, 3571-3594.

Vehtari, A., Gelman, A., and Gabry, J. (2017a). Practical Bayesian model evaluation using leave-one-out cross-validation and WAIC. Statistics and Computing. 27(5), 1413–1432. doi:10.1007/s11222-016-9696-4 (journal version, preprint arXiv:1507.04544).

Vehtari, A., Gelman, A., and Gabry, J. (2017b). Pareto smoothed importance sampling. preprint arXiv:1507.02646

Vehtari A, Gabry J, Magnusson M, Yao Y, Gelman A (2019). “loo: Efficient leave-one-out cross-validation and WAIC for Bayesian models.” R package version 2.2.0, <URL: https://mc-stan.org/loo>.
}
