% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{getModelSlots}
\alias{getModelSlots}
\alias{getModelSlots,bayesGAMfit-method}
\title{Return one or slots from the \code{Stan} model in \code{bayesGAM}}
\usage{
getModelSlots(object, ...)

\S4method{getModelSlots}{bayesGAMfit}(object, name = "X")
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit}}

\item{...}{Additional arguments for \code{getModelSlots}}

\item{name}{Character name of slot in \code{glmModel}
\itemize{
\item X Fixed effects design matrix
\item Z Random effects design matrix
\item Zlst list of individual random effects design matrices that, combined, form \code{Z}
\item Zarray array of individual random effects design matrices.  Used for multiple response models
\item max_col maximum number of columns of an individual \code{Z} matrix.  Padding for STAN
\item y numeric response matrix
\item p number of beta parameters
\item r number of eps parameters
\item q number of lambda parameters
\item n number of records in the dataset
\item has_intercept logical of whether the model includes an intercept term
\item zvars number of random effects variables
\item names_beta parameter names for beta
\item names_u parameter names for the random effects
\item names_y response names
\item prior \code{prior} object with priors used in the model
\item knots list of knots used in non-parametric functions
\item basis character indicating basis function.  \code{tps} for thin-plate splines and \code{trunc.poly} for truncated polynomial
\item npargs arguments passed to non-parametric functions in the model
\item npterms variables used in non-parametric functions
\item sub_form formula with the \code{np} terms removed
\item random_intercept logical indicator of whether a random effects intercept is used
\item multresponse logical indicator of whether the model is multiple response
}}
}
\value{
Contents of slot in \code{glmModel}
}
\description{
Contains the objects and parameters passed to Stan in object of type \code{glmModel}, contained in object type \code{bayesGAMfit}
}
\examples{
require(stats); require(graphics)
f <- bayesGAM(weight ~ np(height), data = women, family = gaussian, 
              iter = 500, chains = 1)
getModelSlots(f, "X")
}
