% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fg_team_batter.R
\name{fg_team_batter}
\alias{fg_team_batter}
\title{\strong{Scrape Team Batter Leaderboards from FanGraphs}}
\usage{
fg_team_batter(x, y, league = "all", qual = "y", ind = 1, exc_p = TRUE)
}
\arguments{
\item{x}{First season for which you want data.}

\item{y}{Last season for which you want data. If multiple years selected, data returned will be aggregate data for the date range. If y = x, function will return single-season data.}

\item{league}{Option for limiting results to different leagues or overall results. Options are "al", "nl", or "all".}

\item{qual}{Whether you want only batters/pitchers that qualified in a given season, or the minimum number of plate appearances for inclusion. If you only want qualified hitters, use qual. If a minimum number of plate appearaces/innings pitched, use the number desired. Defaults to "y".}

\item{ind}{Whether or not to break the seasons out individual, or roll them up together. 1 = split seasons, 0 = aggregate seasons.}

\item{exc_p}{(logical) Whether or not to exclude pitchers from the batter leaderboards. TRUE = exclude pitchers, FALSE = retain pitchers.}
}
\value{
A data frame of batter data.\tabular{ll}{
   col_name \tab types \cr
   Season \tab character \cr
   # \tab character \cr
   Team \tab character \cr
   G \tab numeric \cr
   AB \tab numeric \cr
   PA \tab numeric \cr
   H \tab numeric \cr
   1B \tab numeric \cr
   2B \tab numeric \cr
   3B \tab numeric \cr
   HR \tab numeric \cr
   R \tab numeric \cr
   RBI \tab numeric \cr
   BB \tab numeric \cr
   IBB \tab numeric \cr
   SO \tab numeric \cr
   HBP \tab numeric \cr
   SF \tab numeric \cr
   SH \tab numeric \cr
   GDP \tab numeric \cr
   SB \tab numeric \cr
   CS \tab numeric \cr
   AVG \tab numeric \cr
   GB \tab numeric \cr
   FB \tab numeric \cr
   LD \tab numeric \cr
   IFFB \tab numeric \cr
   Pitches \tab numeric \cr
   Balls \tab numeric \cr
   Strikes \tab numeric \cr
   IFH \tab numeric \cr
   BU \tab numeric \cr
   BUH \tab numeric \cr
   BB_pct \tab numeric \cr
   K_pct \tab numeric \cr
   BB_K \tab numeric \cr
   OBP \tab numeric \cr
   SLG \tab numeric \cr
   OPS \tab numeric \cr
   ISO \tab numeric \cr
   BABIP \tab numeric \cr
   GB_FB \tab numeric \cr
   LD_pct \tab numeric \cr
   GB_pct \tab numeric \cr
   FB_pct \tab numeric \cr
   IFFB_pct \tab numeric \cr
   HR_FB \tab numeric \cr
   IFH_pct \tab numeric \cr
   BUH_pct \tab numeric \cr
   wOBA \tab numeric \cr
   wRAA \tab numeric \cr
   wRC \tab numeric \cr
   Bat \tab numeric \cr
   Fld \tab numeric \cr
   Rep \tab numeric \cr
   Pos \tab numeric \cr
   RAR \tab numeric \cr
   WAR \tab numeric \cr
   Dol \tab numeric \cr
   Spd \tab numeric \cr
   wRC_plus \tab numeric \cr
   WPA \tab numeric \cr
   WPA_minus \tab numeric \cr
   WPA_plus \tab numeric \cr
   RE24 \tab numeric \cr
   REW \tab numeric \cr
   pLI \tab numeric \cr
   phLI \tab numeric \cr
   PH \tab numeric \cr
   WPA_LI \tab numeric \cr
   Clutch \tab numeric \cr
   FBall_pct \tab numeric \cr
   FBv \tab numeric \cr
   SL_pct \tab numeric \cr
   SLv \tab numeric \cr
   CT_pct \tab numeric \cr
   CTv \tab numeric \cr
   CB_pct \tab numeric \cr
   CBv \tab numeric \cr
   CH_pct \tab numeric \cr
   CHv \tab numeric \cr
   SF_pct \tab numeric \cr
   SFv \tab numeric \cr
   KN_pct \tab numeric \cr
   KNv \tab numeric \cr
   XX_pct \tab numeric \cr
   PO_pct \tab numeric \cr
   wFB \tab numeric \cr
   wSL \tab numeric \cr
   wCT \tab numeric \cr
   wCB \tab numeric \cr
   wCH \tab numeric \cr
   wSF \tab numeric \cr
   wKN \tab numeric \cr
   wFB_C \tab numeric \cr
   wSL_C \tab numeric \cr
   wCT_C \tab numeric \cr
   wCB_C \tab numeric \cr
   wCH_C \tab numeric \cr
   wSF_C \tab numeric \cr
   wKN_C \tab numeric \cr
   O-Swing_pct \tab numeric \cr
   Z-Swing_pct \tab numeric \cr
   Swing_pct \tab numeric \cr
   O-Contact_pct \tab numeric \cr
   Z-Contact_pct \tab numeric \cr
   Contact_pct \tab numeric \cr
   Zone_pct \tab numeric \cr
   F-Strike_pct \tab numeric \cr
   SwStr_pct \tab numeric \cr
   BsR \tab numeric \cr
   FA_pct (sc) \tab numeric \cr
   FT_pct (sc) \tab numeric \cr
   FC_pct (sc) \tab numeric \cr
   FS_pct (sc) \tab numeric \cr
   FO_pct (sc) \tab numeric \cr
   SI_pct (sc) \tab numeric \cr
   SL_pct (sc) \tab numeric \cr
   CU_pct (sc) \tab numeric \cr
   KC_pct (sc) \tab numeric \cr
   EP_pct (sc) \tab numeric \cr
   CH_pct (sc) \tab numeric \cr
   SC_pct (sc) \tab numeric \cr
   KN_pct (sc) \tab numeric \cr
   UN_pct (sc) \tab numeric \cr
   vFA (sc) \tab numeric \cr
   vFT (sc) \tab numeric \cr
   vFC (sc) \tab numeric \cr
   vFS (sc) \tab numeric \cr
   vFO (sc) \tab numeric \cr
   vSI (sc) \tab numeric \cr
   vSL (sc) \tab numeric \cr
   vCU (sc) \tab numeric \cr
   vKC (sc) \tab numeric \cr
   vEP (sc) \tab numeric \cr
   vCH (sc) \tab numeric \cr
   vSC (sc) \tab numeric \cr
   vKN (sc) \tab numeric \cr
   FA-X (sc) \tab numeric \cr
   FT-X (sc) \tab numeric \cr
   FC-X (sc) \tab numeric \cr
   FS-X (sc) \tab numeric \cr
   FO-X (sc) \tab numeric \cr
   SI-X (sc) \tab numeric \cr
   SL-X (sc) \tab numeric \cr
   CU-X (sc) \tab numeric \cr
   KC-X (sc) \tab numeric \cr
   EP-X (sc) \tab numeric \cr
   CH-X (sc) \tab numeric \cr
   SC-X (sc) \tab numeric \cr
   KN-X (sc) \tab numeric \cr
   FA-Z (sc) \tab numeric \cr
   FT-Z (sc) \tab numeric \cr
   FC-Z (sc) \tab numeric \cr
   FS-Z (sc) \tab numeric \cr
   FO-Z (sc) \tab numeric \cr
   SI-Z (sc) \tab numeric \cr
   SL-Z (sc) \tab numeric \cr
   CU-Z (sc) \tab numeric \cr
   KC-Z (sc) \tab numeric \cr
   EP-Z (sc) \tab numeric \cr
   CH-Z (sc) \tab numeric \cr
   SC-Z (sc) \tab numeric \cr
   KN-Z (sc) \tab numeric \cr
   wFA (sc) \tab numeric \cr
   wFT (sc) \tab numeric \cr
   wFC (sc) \tab numeric \cr
   wFS (sc) \tab numeric \cr
   wFO (sc) \tab numeric \cr
   wSI (sc) \tab numeric \cr
   wSL (sc) \tab numeric \cr
   wCU (sc) \tab numeric \cr
   wKC (sc) \tab numeric \cr
   wEP (sc) \tab numeric \cr
   wCH (sc) \tab numeric \cr
   wSC (sc) \tab numeric \cr
   wKN (sc) \tab numeric \cr
   wFA_C (sc) \tab numeric \cr
   wFT_C (sc) \tab numeric \cr
   wFC_C (sc) \tab numeric \cr
   wFS_C (sc) \tab numeric \cr
   wFO_C (sc) \tab numeric \cr
   wSI_C (sc) \tab numeric \cr
   wSL_C (sc) \tab numeric \cr
   wCU_C (sc) \tab numeric \cr
   wKC_C (sc) \tab numeric \cr
   wEP_C (sc) \tab numeric \cr
   wCH_C (sc) \tab numeric \cr
   wSC_C (sc) \tab numeric \cr
   wKN_C (sc) \tab numeric \cr
   O-Swing_pct (sc) \tab numeric \cr
   Z-Swing_pct (sc) \tab numeric \cr
   Swing_pct (sc) \tab numeric \cr
   O-Contact_pct (sc) \tab numeric \cr
   Z-Contact_pct (sc) \tab numeric \cr
   Contact_pct (sc) \tab numeric \cr
   Zone_pct (sc) \tab numeric \cr
   Pace \tab numeric \cr
   Def \tab numeric \cr
   wSB \tab numeric \cr
   UBR \tab numeric \cr
   AgeRng \tab numeric \cr
   Off \tab numeric \cr
   Lg \tab numeric \cr
   wGDP \tab numeric \cr
   Pull_pct \tab numeric \cr
   Cent_pct \tab numeric \cr
   Oppo_pct \tab numeric \cr
   Soft_pct \tab numeric \cr
   Med_pct \tab numeric \cr
   Hard_pct \tab numeric \cr
   TTO_pct \tab numeric \cr
   CH_pct_pi \tab numeric \cr
   CS_pct_pi \tab numeric \cr
   CU_pct_pi \tab numeric \cr
   FA_pct_pi \tab numeric \cr
   FC_pct_pi \tab numeric \cr
   FS_pct_pi \tab numeric \cr
   KN_pct_pi \tab numeric \cr
   SB_pct_pi \tab numeric \cr
   SI_pct_pi \tab numeric \cr
   SL_pct_pi \tab numeric \cr
   XX_pct_pi \tab numeric \cr
   vCH_pi \tab numeric \cr
   vCS_pi \tab numeric \cr
   vCU_pi \tab numeric \cr
   vFA_pi \tab numeric \cr
   vFC_pi \tab numeric \cr
   vFS_pi \tab numeric \cr
   vKN_pi \tab numeric \cr
   vSB_pi \tab numeric \cr
   vSI_pi \tab numeric \cr
   vSL_pi \tab numeric \cr
   vXX_pi \tab numeric \cr
   CH-X_pi \tab numeric \cr
   CS-X_pi \tab numeric \cr
   CU-X_pi \tab numeric \cr
   FA-X_pi \tab numeric \cr
   FC-X_pi \tab numeric \cr
   FS-X_pi \tab numeric \cr
   KN-X_pi \tab numeric \cr
   SB-X_pi \tab numeric \cr
   SI-X_pi \tab numeric \cr
   SL-X_pi \tab numeric \cr
   XX-X_pi \tab numeric \cr
   CH-Z_pi \tab numeric \cr
   CS-Z_pi \tab numeric \cr
   CU-Z_pi \tab numeric \cr
   FA-Z_pi \tab numeric \cr
   FC-Z_pi \tab numeric \cr
   FS-Z_pi \tab numeric \cr
   KN-Z_pi \tab numeric \cr
   SB-Z_pi \tab numeric \cr
   SI-Z_pi \tab numeric \cr
   SL-Z_pi \tab numeric \cr
   XX-Z_pi \tab numeric \cr
   wCH_pi \tab numeric \cr
   wCS_pi \tab numeric \cr
   wCU_pi \tab numeric \cr
   wFA_pi \tab numeric \cr
   wFC_pi \tab numeric \cr
   wFS_pi \tab numeric \cr
   wKN_pi \tab numeric \cr
   wSB_pi \tab numeric \cr
   wSI_pi \tab numeric \cr
   wSL_pi \tab numeric \cr
   wXX_pi \tab numeric \cr
   wCH_C_pi \tab numeric \cr
   wCS_C_pi \tab numeric \cr
   wCU_C_pi \tab numeric \cr
   wFA_C_pi \tab numeric \cr
   wFC_C_pi \tab numeric \cr
   wFS_C_pi \tab numeric \cr
   wKN_C_pi \tab numeric \cr
   wSB_C_pi \tab numeric \cr
   wSI_C_pi \tab numeric \cr
   wSL_C_pi \tab numeric \cr
   wXX_C_pi \tab numeric \cr
   O-Swing_pct_pi \tab numeric \cr
   Z-Swing_pct_pi \tab numeric \cr
   Swing_pct_pi \tab numeric \cr
   O-Contact_pct_pi \tab numeric \cr
   Z-Contact_pct_pi \tab numeric \cr
   Contact_pct_pi \tab numeric \cr
   Zone_pct_pi \tab numeric \cr
   Pace_pi \tab numeric \cr
}
}
\description{
This function allows you to scrape all leaderboard statistics (basic and advanced) from FanGraphs.com.
}
\examples{
\donttest{
  try(fg_team_batter(x = 2015, y = 2015, qual = 200))
}
}
