% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_circle.R
\name{sim_circle}
\alias{sim_circle}
\title{Simulate Data from Hyper-Sphere for Classification Problems}
\usage{
sim_circle(n, dim = 5)
}
\arguments{
\item{n}{number of data points to generate}

\item{dim}{number of dimension of the problem, no less than 2}
}
\value{
Returns a list with components
\item{x}{input values (independent variables)}
\item{y}{0/1 output values (dependent variable)}
}
\description{
The classification problem Circle is described in the BARK paper (2008).
Inputs are \emph{dim} independent variables uniformly
distributed on the interval \eqn{[-1,1]}, only the first 2
out of these \emph{dim} are actually signals.
Outputs are created according to the formula
\deqn{y = 1(x1^2+x2^2 \le 2/\pi)}
}
\examples{
sim_circle(n=100, dim=5)

}
\references{
Ouyang, Zhi (2008) Bayesian Additive Regression Kernels.
Duke University. PhD dissertation, Chapter 3.
}
\seealso{
Other bark simulation functions: 
\code{\link{sim_Friedman1}()},
\code{\link{sim_Friedman2}()},
\code{\link{sim_Friedman3}()}

Other bark functions: 
\code{\link{bark-package-deprecated}},
\code{\link{bark-package}},
\code{\link{bark}()},
\code{\link{sim_Friedman1}()},
\code{\link{sim_Friedman2}()},
\code{\link{sim_Friedman3}()}
}
\concept{bark functions}
\concept{bark simulation functions}
