% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_babette_path.R
\name{get_babette_path}
\alias{get_babette_path}
\title{Get the full path of a file in the \code{inst/extdata} folder}
\usage{
get_babette_path(filename)
}
\arguments{
\item{filename}{the file's name, without the path}
}
\value{
the full path of the filename, if and only if
  the file is present. Will stop otherwise.
}
\description{
Get the full path of a file in the \code{inst/extdata} folder
}
\examples{
library(testthat)

expect_true(file.exists(get_babette_path("anthus_aco.fas")))
expect_true(file.exists(get_babette_path("anthus_nd2.fas")))

expect_error(get_babette_path("abs.ent"))
}
\seealso{
for more files, use \code{\link{get_babette_paths}}
}
\author{
Richèl J.C. Bilderbeek
}
