% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_enrich_tables.R
\name{read_enrich_tables}
\alias{read_enrich_tables}
\title{Read enrichment results from tables}
\usage{
read_enrich_tables(
  enrich_table_path = "./results",
  log2FC_threshold = 0,
  padj_threshold = 0.05,
  which_list = c("up_genes", "down_genes", "up_down_genes", "everything"),
  from_autoGO = TRUE,
  files_format = NULL
)
}
\arguments{
\item{enrich_table_path}{Specify the full path to the folder where enrichment tables have to read from (all fitting files in any subdirectory will be loaded).}

\item{log2FC_threshold}{Threshold value for log2(Fold Change) for considering genes as differentially expressed (default = 0).}

\item{padj_threshold}{Threshold value for adjusted p-value significance (Defaults to 0.05).}

\item{which_list}{It can be: "up_genes","down_genes","up_down_genes","everything". Select a list of genes to perform the enrichment. Respectively, only up regulated genes (up_genes), only down regulated genes (down_genes), both up and down regulated genes (up_down_genes), or (everything) allow to load all the three kind of lists separately and it is employed also for lists not from differential analysis.}

\item{from_autoGO}{Default is TRUE, set to FALSE if the lists you want to upload are not from a differential expression analysis.}

\item{files_format}{Default is NULL, when from_autoGO = FALSE it is mandatory to provide the extension of the list of genes you want to upload.}
}
\value{
List of enrichment tables, each one being a tibble object.
}
\description{
Helper function to read all the enrichment results in order to proceed with the visualization in an automated way.
}
\examples{
\dontrun{
enrich_tables <- read_enrich_tables(
  enrich_table_path = "./results",
  log2FC_threshold = 0,
  padj_threshold = 0.05,
  which_list = "down_genes",
  from_autoGO = T,
  files_format = NULL
)
}
}
