% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrCUSUM_getxxx_binom.R
\name{getAve_binomial}
\alias{getAve_binom}
\alias{getAve_binomial}
\alias{getAve_zibinom}
\title{Compute ATSs and Other Informations on (Zero-Inflated) Binomial CUSUM Chart}
\usage{
getAve_binom(size, prob, refv, contl, c.zero = 0, warnl = 0, ds = 1,
  dl = NULL, di = NULL, maxndec = 7L, maxnumsubI = 6000L)

getAve_zibinom(rho, size, prob, refv, contl, c.zero = 0, warnl = 0,
  ds = 1, dl = NULL, di = NULL, maxndec = 7L, maxnumsubI = 6000L)
}
\arguments{
\item{rho}{A length-one numeric vector of zero-inflated parameter in [0,1).}

\item{size}{A length-one non-negative integer-valued vector
of number of trials.}

\item{prob}{A length-one numeric vector of probability of success in [0,1].}

\item{refv}{A reference value of CUSUM statistic.}

\item{contl}{A control limit in CUSUM control scheme.}

\item{c.zero}{An initial state of CUSUM statistic (default is 0).}

\item{warnl}{A warning limit in VSI control scheme (default is 0).}

\item{ds}{The shorter sampling interval in VSI CUSUM control scheme (default is 1).}

\item{dl}{The longer sampling interval in VSI CUSUM control scheme.}

\item{di}{The sampling interval at initial state in VSI CUSUM control scheme.}

\item{maxndec}{The maximum number of decimal places
of \code{refv} (\eqn{\le} 7L).}

\item{maxnumsubI}{The maximum number of sub-intervals in [100,6000] to be used in
applying the Markov chain approach.}
}
\value{
A list from \code{\link{getAve}}.
  See \code{\link{getAve}} for more information.
}
\description{
Computation of ANSSs, ATSs and other related informations on
  (zero-inflated) binomial CUSUM chart.
}
\details{
\code{\link{getAve_binom}} and \code{\link{getAve_zibinom}} are
  wrapper functions of \code{\link{getAve}}
  for (zero-inflated) binomial CUSUM chart.
}
\examples{
# Example 1: Reproduction of results from Rakitzis et al. (2016)
rho <- 0.9
size <- 100
prob0 <- 0.01
refv <- 0.26
contl <- 3.86
deltas <- seq(1, 2, 0.1)
ANSSs <- numeric(length(deltas))
for(i in seq(deltas)) {
  prob1 <- deltas[i] * prob0
  ANSSs[i] <- getAve_zibinom(rho = rho, size = size, prob = prob1,
                             refv = refv, contl = contl)$ANSS
}
names(ANSSs) <- deltas
ANSSs <- round(ANSSs, 2)
ANSSs

# Example 2: ANSS profiles (h in seq(10L))
rho <- 0.9
size <- 100
prob0 <- 0.01
refv <- 0.26
h <- seq(10L)
ANSSs <- numeric(10)
for(i in seq(ANSSs)) {
  ANSSs[i] <- getAve_zibinom(rho = rho, size = size, prob = prob0,
                             refv = refv, contl = h[i], ds = 1)$ANSS
}
ANSSs

}
\references{
Rakitzis et al. (2016).
   CUSUM Control Charts for the Monitoring of Zero-inflated Binomial Processes,
   \emph{Quality and Reliability Engineering International},
   \strong{32}, 465-483.
}
\seealso{
\code{\link{getAve}}, \link{getAve_Poisson}.
}

