% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-info}
\alias{node-info}
\alias{node_matches}
\alias{node_inside}
\alias{node_has}
\alias{node_precedes}
\alias{node_follows}
\title{Get more precise information on a node}
\usage{
node_matches(x, ..., files = NULL)

node_inside(x, ..., files = NULL)

node_has(x, ..., files = NULL)

node_precedes(x, ..., files = NULL)

node_follows(x, ..., files = NULL)
}
\arguments{
\item{x}{A node, either from \code{\link[=tree_root]{tree_root()}} or from another \verb{node_*()}
function.}

\item{...}{Any number of rules created with \code{ast_rule()}.}

\item{files}{A vector of filenames containing rules. Those must be \code{.yaml}
files.}
}
\value{
A list containing as many elements as there are nodes as input.
}
\description{
Get more precise information on a node
}
\examples{
src <- "
print('hi')
fn <- function() {
  print('hello')
}
"
root <- src |>
  tree_new() |>
  tree_root()

some_node <- root |>
  node_find(ast_rule(pattern = "print($A)"))

node_text(some_node)

# Check if a node matches a specific rule
some_node |>
  node_get_match("A") |>
  node_matches(ast_rule(kind = "argument"))

# Check if a node is inside another one
some_node |>
  node_get_match("A") |>
  node_inside(ast_rule(kind = "call"))
}
