% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/remove.R
\docType{methods}
\name{remove_NA}
\alias{remove_NA}
\alias{remove_NA-method}
\alias{missing}
\alias{remove_NA,ANY-method}
\title{Remove Rows/Columns with Missing Values}
\usage{
remove_NA(x, ...)

\S4method{remove_NA}{ANY}(x, margin = 1, all = FALSE, verbose = getOption("arkhe.verbose"))
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscripts which the
function will be applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}
}
\description{
Removes rows/columns that contain \link[=NA]{missing values}.
}
\examples{
## Create a data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Remove rows with NA
remove_NA(X, margin = 1)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{clean_whitespace}()},
\code{\link{remove_Inf}()},
\code{\link{remove_constant}()},
\code{\link{remove_empty}()},
\code{\link{remove_zero}()},
\code{\link{replace_Inf}()},
\code{\link{replace_NA}()},
\code{\link{replace_empty}()},
\code{\link{replace_zero}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
