% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-utils}
\alias{predicate-utils}
\alias{is_empty}
\alias{is_named}
\title{Utility Predicates}
\usage{
is_empty(x)

is_named(x)
}
\arguments{
\item{x}{An object to be tested.}
}
\value{
A \code{\link{logical}} scalar.
}
\description{
\itemize{
\item \code{is_empty()} checks if a vector or list is empty.
\item \code{is_missing()} checks if a vector or list contains missing values.
\item \code{is_named()} checks if an object is named.
\item \code{is_uuid()} checks if a string is a canonically formatted UUID that is
version 1 through 5 and is the appropriate Variant as per RFC4122.
}
}
\seealso{
Other predicates: 
\code{\link{predicate-graph}},
\code{\link{predicate-matrix}},
\code{\link{predicate-numeric}},
\code{\link{predicate-scalar}},
\code{\link{predicate-trend}},
\code{\link{predicate-type}}
}
\concept{predicates}
