% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_update.R
\name{orsf_update}
\alias{orsf_update}
\title{Update Forest Parameters}
\usage{
orsf_update(object, ..., modify_in_place = FALSE, no_fit = NULL)
}
\arguments{
\item{object}{(\emph{ObliqueForest}) an oblique random forest object (see \link{orsf}).}

\item{...}{arguments to plug into \link{orsf} that will be used to define the
update. These arguments include:
\itemize{
\item \code{data}
\item \code{formula}
\item \code{control}
\item \code{weights}
\item \code{n_tree}
\item \code{n_split}
\item \code{n_retry}
\item \code{n_thread}
\item \code{mtry}
\item \code{sample_with_replacement}
\item \code{sample_fraction}
\item \code{leaf_min_events}
\item \code{leaf_min_obs}
\item \code{split_rule}
\item \code{split_min_events}
\item \code{split_min_obs}
\item \code{split_min_stat}
\item \code{pred_type}
\item \code{oobag_pred_horizon}
\item \code{oobag_eval_every}
\item \code{oobag_fun}
\item \code{importance}
\item \code{importance_max_pvalue}
\item \code{group_factors}
\item \code{tree_seeds}
\item \code{na_action}
\item \code{verbose_progress}
}

Note that you can update \code{control}, but you cannot change the type
of forest. For example, you can't go from classification to regression
with \code{orsf_update}.}

\item{modify_in_place}{(\emph{logical}) if \code{TRUE}, \code{object} will be modified
by the inputs specified in \code{...}. Be cautious, as modification in place
will overwrite existing data. If \code{FALSE} (the default), \code{object} will
be copied and then the modifications will be applied to the copy,
leaving the original \code{object} unmodified.}

\item{no_fit}{(\emph{logical}) if \code{TRUE}, model fitting steps are defined and
saved, but training is not initiated. The object returned can be
directly submitted to \code{orsf_train()} so long as \code{attach_data} is \code{TRUE}.}
}
\value{
an \code{ObliqueForest} object.
}
\description{
Update Forest Parameters
}
\details{
There are several dynamic inputs in \code{orsf} with default values of \code{NULL}.
Specifically, these inputs are \code{control}, \code{weights}, \code{mtry}, \code{split_rule},
\code{split_min_stat}, \code{pred_type}, \code{pred_horizon}, \code{oobag_eval_function},
\code{tree_seeds}, and \code{oobag_eval_every}. If no explicit value is given for
these inputs in the call, they \emph{will be re-formed}. For example, if
an initial forest includes 17 predictors, the default \code{mtry} is the
smallest integer that is greater than or equal to the square root of 17,
i.e., 5. Then, if you make an updated forest with 1 less predictor and
you do not explicitly say \code{mtry = 5}, then \code{mtry} will be re-initialized
in the update based on the available 16 predictors, and the resulting
value of \code{mtry} will be 4. This is done to avoid many potential errors
that would occur if the dynamic outputs were not re-initialized.
}
\examples{

\dontrun{
# initial fit has mtry of 5
fit <- orsf(pbc_orsf, time + status ~ . -id)

# note that mtry is now 4 (see details)
fit_new <- orsf_update(fit, formula = . ~ . - edema, n_tree = 100)

# prevent dynamic updates by specifying inputs you want to freeze.
fit_newer <- orsf_update(fit_new, mtry = 2)
}


}
