/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Label;
import com.starbase.starteam.View;
import com.starbase.util.OLEDate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.starteam.StarTeamTask;

public class StarTeamLabel
extends StarTeamTask {
    private String labelName;
    private String description;
    private boolean buildlabel = false;
    private boolean revisionlabel = false;
    private OLEDate lastBuild = null;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    public void setLabel(String label) {
        this.labelName = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBuildLabel(boolean buildlabel) {
        this.buildlabel = buildlabel;
    }

    public void setRevisionLabel(boolean revisionlabel) {
        this.revisionlabel = revisionlabel;
    }

    public void setLastBuild(String lastbuild) throws BuildException {
        try {
            Date lastBuildTime = DATE_FORMAT.parse(lastbuild);
            this.lastBuild = new OLEDate(lastBuildTime);
        }
        catch (ParseException e) {
            throw new BuildException("Unable to parse the date '" + lastbuild + "'", (Throwable)e);
        }
    }

    public void execute() throws BuildException {
        if (this.revisionlabel && this.buildlabel) {
            throw new BuildException("'revisionlabel' and 'buildlabel' both specified.  A revision label cannot be a build label.");
        }
        try {
            block7: {
                try {
                    View snapshot = this.openView();
                    if (this.revisionlabel) {
                        new Label(snapshot, this.labelName, this.description).update();
                        this.log("Created Revision Label " + this.labelName);
                        break block7;
                    }
                    if (null != this.lastBuild) {
                        new Label(snapshot, this.labelName, this.description, this.lastBuild, this.buildlabel).update();
                        this.log("Created View Label (" + (this.buildlabel ? "" : "non-") + "build) " + this.labelName + " as of " + this.lastBuild.toString());
                        break block7;
                    }
                    new Label(snapshot, this.labelName, this.description, this.buildlabel).update();
                    this.log("Created View Label (" + (this.buildlabel ? "" : "non-") + "build) " + this.labelName);
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.disconnectFromServer();
            throw throwable;
        }
        this.disconnectFromServer();
    }

    protected View createSnapshotView(View raw) {
        return raw;
    }
}

