% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.anomaly_series.R
\name{plot.anomaly_series}
\alias{plot.anomaly_series}
\title{Plots an anomaly_series object.}
\usage{
\method{plot}{anomaly_series}(x, xlab = "", ylab = "", ...)
}
\arguments{
\item{x}{anomaly_series object}

\item{xlab}{Character string containing label for the x-axis.}

\item{ylab}{Character string containing label for the y-axis.}

\item{...}{Other parameters to be passed to plotting methods.}
}
\description{
Plot method for anomaly_series objects as returned by the \code{\link{anomaly_series}} method.
}
\examples{
library(anomaly)
set.seed(2018)
# Generate data typically following a normal distribution with mean 0 and variance 1. 
# Then introduce 3 anomaly windows and 4 point outliers.
x  = rnorm(5000)
x[401:500]   = rnorm(100,4,1)
x[1601:1800] = rnorm(200,0,0.01)
x[3201:3500] = rnorm(300,0,10)
x[c(1000,2000,3000,4000)] = rnorm(4,0,100)
inferred_anomalies = anomaly_series(x)
plot(inferred_anomalies)

}
