% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globe.r
\name{globe}
\alias{globe}
\alias{globe.mesh3d}
\alias{globe.default}
\title{Geocentric (XYZ) coordinates}
\usage{
globe(x, ...)

\method{globe}{mesh3d}(x, gproj = NULL, ...)

\method{globe}{default}(x, gproj = "+proj=geocent +datum=WGS84", ...)
}
\arguments{
\item{x}{a silicate model or mesh3d}

\item{...}{arguments to methods (none used)}

\item{gproj}{Geocentric PROJ.4 string, defaults to WGS84}
}
\value{
object with vertices table modified
}
\description{
Convert longitude/latitude coordinates to geocentric coordinates.
}
\details{
With silicate data checks are made for the projection in use, but
not for mesh3d. In that case data are assumed to be
'longitude,latitude,elevation'.
}
\examples{
data(simpleworld)
g <- globe(silicate::PATH(as(simpleworld, "SpatialLinesDataFrame")))
if (interactive()) {
 plot(g, lwd = 3)
 plot3d(g)
}
}
