% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotZonalMeans.R
\name{plotZonalMeans}
\alias{plotZonalMeans}
\title{Plot zonal mean values of model and reference data in a single figure}
\usage{
plotZonalMeans(mod.path.list, modelIDs, myVariables, metric = "mean",
  lat.range = c(-50, 80), plot.width = 6, plot.height = 10,
  outputDir = FALSE, myFilename = "zonalMeans.pdf",
  legendLocation = "topright", plotRef = TRUE, subcaption = "")
}
\arguments{
\item{mod.path.list}{A List of directories where AMBER output is stored for different model runs,
e.g. list(mod01.path, mod02.path, mod03.path)}

\item{modelIDs}{An R object with the different model run IDs, e.g. c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5', 'CLASSIC.CRUNCEP')}

\item{myVariables}{An R object with the variable names of interest, e.g. c('GPP.FluxCom', 'RECO.FluxCom').}

\item{metric}{Specify for what statistical metric you wish to plot zonal means.
Current options are 'mean', 'bias', 'crmse', 'phase', 'iav', 'sd', 'bias.score', 'rmse.score', 'phase.score', and 'iav.score'.}

\item{lat.range}{Latitudinal range of ticks and labels on the horizontal axis, e.g. c(-50, 80).}

\item{plot.width}{A number that gives the desired plot width, e.g. 6.}

\item{plot.height}{A number that gives the desired plot height, e.g. 10.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{myFilename}{A string that gives name of the Figure, e.g. 'zonalMeans.pdf'.}

\item{legendLocation}{A string that specifies the location of the model ID legend, e.g. 'topright'.}

\item{plotRef}{Logical. If FALSE, reference data is not plotted. Default is TRUE.}

\item{subcaption}{A string that defines the subcaption of the figure, e.g. '(a)'.}
}
\value{
A figure that shows zonal mean values of model and reference data.
}
\description{
This function plots zonal mean values of model and reference data, computed from \link{zonalMeanStats}, for a selection of variables.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

mod01.path <- system.file('extdata/SIMod01', package = 'amber')
mod02.path <- system.file('extdata/SIMod02', package = 'amber')
mod.path.list <- list(mod01.path, mod02.path)
modelIDs <- c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5')
myVariables <- c('GPP.MODIS', 'LAI.AVHRR')
plotZonalMeans(mod.path.list, modelIDs, myVariables, metric = 'mean')

}
