% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalSumsTable.R
\name{globalSumsTable}
\alias{globalSumsTable}
\title{Table of globally summed values and corresponding biases.}
\usage{
globalSumsTable(mod.path.list, modelIDs, variableNames, unitLaTeX,
  conversionFactor, outputDir = FALSE)
}
\arguments{
\item{mod.path.list}{A list with paths for each model run, e.g. mod.path.list <- list(mod01.path, mod02.path, mod03.path).}

\item{modelIDs}{An R object with the different model run IDs, e.g. c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5', 'CLASSIC.CRUNCEP')}

\item{variableNames}{Variable names, e.g. c('GPP', 'CSOIL', 'BURNT')}

\item{unitLaTeX}{Desired output units in LaTeX format, e.g. c('PgC yr$^{-1}$', 'PgC', '10$^6$ km$^2$ yr^{-1}')}

\item{conversionFactor}{Factors that convert the unit of the input files into the desired output unit,
e.g. c((10^(15) / 365.25)^(-1), 10^(-12), 12*10^(-14)).
Examples of typical conversions include (i) carbon fluxes from gC/day to PgC/yr,
(ii) carbon stocks from kgC to PgC, and fractional area burnt from percentage per month to 10^6 km2 per year.
Conversion from gC/day to PgC/yr: 1 PgC/yr = 10^15 gC/yr = 10^15 / 365.25 gC/day. Taking the reciprocal leads to the conversion factor, i.e. (10^(15) / 365.25)^(-1).
Conversion from kgC to PgC: 1 PgC = 10^15 gC = 10^12 kgC. The resulting conversion factor is 10^(-12).
Conversion from percentage of grid cell per month to 10^6 km2 per year: 10^6 km2 per year = 10^12 m2 per year = 1/12 * 10^12 m2 per month.
To account for the conversion from percentage to fraction, we need to multiply by 100. The resulting conversion factor is 12*10^(-14).}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output table in LaTeX format will only be written if the user specifies an output directory.}
}
\value{
A table with globally summed values and corresponding biases.
}
\description{
This function produces a table of globally summed values and
corresponding biases when comparing model and reference data. The table provides
the variable name, the reference data name, globally summed values from the model
and reference data, the absolute bias, the relative bias, units, and time period.
The inputs consist of netCDF files produced by \link{scores.grid.time} and
\link{scores.grid.notime}. The global sums are based on grid cells that model
and reference data have in common.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

mod01.path <- paste(system.file('extdata', package = 'amber'), 'model01', sep = '/')
mod02.path <- paste(system.file('extdata', package = 'amber'), 'model02', sep = '/')

mod.path.list <- list(mod01.path, mod02.path)
modelIDs <- c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5')

variableNames <- c('GPP', 'BURNT')
unitLaTeX <- c('PgC yr$^{-1}$', '10$^6$ km$^2$ yr^{-1}')
conversionFactor <- c((10^(15) / 365.25)^(-1), 12*10^(-14))

globalSumsTable(mod.path.list, modelIDs, variableNames, unitLaTeX, conversionFactor,
outputDir = FALSE)

}
