% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates_auxiliary.R
\name{calc_worker}
\alias{calc_worker}
\title{Perform covariate extraction}
\usage{
calc_worker(
  dataset,
  from,
  locs_vector,
  locs_df,
  fun,
  variable = 1,
  time,
  time_type = c("date", "hour", "year", "yearmonth", "timeless"),
  radius,
  level = NULL,
  max_cells = 1e+08,
  ...
)
}
\arguments{
\item{dataset}{character(1). Dataset name.}

\item{from}{SpatRaster(1). Cleaned \code{SpatRaster} object.}

\item{locs_vector}{SpatVector(1). Cleaned \code{SpatVector} object passed
from \code{calc_prepare_locs()}. Contains location point/polygon values.}

\item{locs_df}{data.frame(1). Cleaned \code{data.frame} object passed from
\code{calc_prepare_locs()}. Contains location identifiers.}

\item{fun}{character(1). Summary function. Passed to \code{terra::extract()}.}

\item{variable}{integer. Position within the layer name containing the
variable name/code.}

\item{time}{integer. Position within the layer name containing the time
value(s).}

\item{time_type}{character(1). Type of time observation. One of "date",
"hour", "year", "yearmonth", "timeless".}

\item{radius}{integer(1). Buffer distance (m). Passed from
\code{calc_prepare_locs()}. Used in column naming.}

\item{level}{integer. Position within the layer name containing the vertical
pressure level value (if applicable). Default = \code{NULL}.}

\item{max_cells}{integer(1). Maximum number of cells to be read at once.
Higher values will expedite processing, but will increase memory usage.
Maximum possible value is \code{2^31 - 1}.
See \code{\link[exactextractr:exact_extract]{exactextractr::exact_extract}} for details.}

\item{...}{Placeholders.}
}
\value{
a \code{data.frame} object
}
\description{
Extract covariate values from \code{SpatRaster} object passed from
\code{process_*()}.
}
\keyword{internal}
