% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_ages.R
\name{cut_ages}
\alias{cut_ages}
\title{Cut integer age vectors}
\usage{
cut_ages(ages, breaks, max_upper = Inf)
}
\arguments{
\item{ages}{\verb{[numeric]}.

Vector of age values.

Double values are coerced to integer prior to categorisation / aggregation.

Must not be NA.}

\item{breaks}{\verb{[integerish]}.

1 or more non-negative cut points in increasing (strictly) order.

These correspond to the left hand side of the desired intervals (e.g. the
closed side of [x, y).

Double values are coerced to integer prior to categorisation.}

\item{max_upper}{\verb{[numeric]}

Represents the maximum upper bound for the resulting intervals.

Double values are rounded up to the nearest (numeric) integer.

Defaults to \code{Inf}.}
}
\value{
A data frame with an ordered factor column (\code{interval}), as well as columns
corresponding to the explicit bounds (\code{lower} and \code{upper}).
Internally both bound columns are stored as double but it can be taken as
part of the function API that \code{lower} is coercible to integer without
any coercion to \code{NA_integer_}. Similarly all values of \code{upper} apart
from those corresponding to \code{max_upper} can be assumed coercible to integer
(\code{max_upper} may or may not depending on the given argument).
}
\description{
\code{cut_ages()} provides categorisation of ages based on specified breaks
which represent the left-hand interval limits. The resulting intervals span
from the minimum break through to a specified \code{max_upper} and will always be
closed on the left and open on the right. Ages below the minimum break, or
above \code{max_upper} will be returned as NA.
}
\examples{

cut_ages(ages = 0:9, breaks = c(0, 3, 5, 10))

cut_ages(ages = 0:9, breaks = c(0, 5))

# Note the following is comparable to a call to
# cut(ages, right = FALSE, breaks = c(breaks, Inf))
ages <- seq.int(from = 0, by = 10, length.out = 10)
breaks <- c(0, 1, 10, 30)
cut_ages(ages, breaks)

# values above max_upper treated as NA
cut_ages(ages = 0:10, breaks = c(0,5), max_upper = 7)

}
