% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthobasis_test.R
\name{orthobasis_test}
\alias{orthobasis_test}
\title{Equality test of two unknown component distributions using polynomial expansions}
\usage{
orthobasis_test(
  samples,
  admixMod,
  K = 3,
  s = 0.49,
  est_method = c("BVdk", "PS"),
  conf_level = 0.95,
  nb_echBoot = NULL,
  bounds_supp = NULL,
  support = c("Real", "Integer", "Positive", "Bounded.continuous", "Bounded.discrete")
)
}
\arguments{
\item{samples}{(List) List of the two samples, each one following the mixture distribution given by l = p*f + (1-p)*g,
with f and p unknown and g known.}

\item{admixMod}{An object of class 'admix_model', containing useful information about distributions and parameters.}

\item{K}{Number of coefficients considered for the polynomial basis expansion.}

\item{s}{Rate at which the normalization factor is set in the penalization rule for model selection (in ]0,1/2[), see 'Details'.}

\item{est_method}{Estimation method to get the component weights, either 'PS' (Patra and Sen estimation) or 'BVdk'
(Bordes and Vendekerkhove estimation). Choosing 'PS' requires to specify the number of bootstrap samples.}

\item{conf_level}{The confidence level, default to 95 percent. Equals 1-alpha, where alpha is the level of the test (type-I error).}

\item{nb_echBoot}{(default to NULL) Number of bootstrap samples, useful when choosing 'PS' estimation method.}

\item{bounds_supp}{(default to NULL) useful if support = 'bounded', a list of minimum and maximum bounds, specified as
following: list( list(min.f1,min.g1,min.f2,min.g2) , list(max.f1,max.g1,max.f2,max.g2) )}

\item{support}{support of the densities under consideration, useful to choose the polynomial orthonormal basis.}
}
\value{
An object of class 'orthobasis_test', containing ten attributes: 1) the number of populations under study (2 in this case);
2) the sizes of samples; 3) the information about the known component distribution; 4) the reject decision of the test; 5) the
confidence level of the test, 6) the p-value of the test; 7) the value of the test statistic; 8) the variance of the test
statistic at each order in the polynomial orthobasis expansion; 9) the selected rank (order) for the test statistic;
10) a vector of estimates, related to the estimated mixing proportions in the two samples.
}
\description{
Tests the null hypothesis (H0: f1=f2) using the decomposition of unknown component densities of two admixture distributions in
an adequate orthonormal polynomial basis. Recall that we have two admixture models with respective probability density
functions (pdf) l1 = p1*f1 + (1-p1)\emph{g1 and l2 = p2}f2 + (1-p2)*g2, where g1 and g2 are the only known elements and l1 and l2
are observed. The admixture weights p1 and p2 thus have to be estimated. For further information on this method, see 'Details' below.
}
\examples{
\donttest{
#### Under the null hypothesis H0.
mixt1 <- twoComp_mixt(n = 300, weight = 0.77,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(list("mean" = 1, "sd" = 1),
                                        list("mean" = 4, "sd" = 1)))
data1 <- getmixtData(mixt1)
admixMod1 <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                        knownComp_param = mixt1$comp.param[[2]])
mixt2 <- twoComp_mixt(n = 500, weight = 0.62,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(list("mean" = 1, "sd" = 1),
                                        list("mean" = -2, "sd" = 0.5)))
data2 <- getmixtData(mixt2)
admixMod2 <- admix_model(knownComp_dist = mixt2$comp.dist[[2]],
                        knownComp_param = mixt2$comp.param[[2]])

orthobasis_test(samples = list(data1,data2),
                admixMod = list(admixMod1,admixMod2),
                K = 3, s = 0.49, nb_echBoot = NULL, support = 'Real',
                bounds_supp = NULL, est_method = 'BVdk')
}

}
\references{
\insertRef{MilhaudPommeretSalhiVandekerkhove2022}{admix}
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
