% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSim.R
\name{plotSim}
\alias{plotSim}
\title{Plot (dis)similarity matrix}
\usage{
plotSim(
  mat,
  type = c("similarity", "dissimilarity"),
  clustering = NULL,
  dendro = NULL,
  palette = heat.colors,
  breaks = 10,
  log = TRUE,
  h = NULL,
  stats = c("R.squared", "D.prime"),
  main = NULL,
  col.clust = "darkblue",
  lwd.clust = 2,
  xaxis = FALSE,
  naxis = 10
)
}
\arguments{
\item{mat}{matrix to plot. It can be of class \code{'matrix'}, 
\code{'dgCMatrix'}, \code{'dsCMatrix'}, \code{'dist'}, \code{'HTCexp'},
\code{'snpMatrix'}.}

\item{type}{input matrix type. Can be either \code{"similarity"} or 
\code{"dissimilarity"} (kernels are supposed to be of type 
\code{"similarity"}).}

\item{clustering}{vector of length the number of rows (columns) of the 
matrix that contains a contiguity constrained clustering (as provided by
\code{\link{select}} for instance). If supplied the clustering is 
superimposed over the heatmap.}

\item{dendro}{\code{\link{chac}} object as provided, e.g., by the function
\code{\link{adjClust}} (or any of the other wrappers).}

\item{palette}{color palette. Default to \code{\link[grDevices]{heat.colors}}}

\item{breaks}{number of breaks used to set colors from the palette. Those
are based on the quantiles of the matrix entries and for skewed distributions
the actual number used to set the palette can be lower than \code{breaks}.}

\item{log}{logical. Should the breaks be based on log-scaled values of the
matrix entries. Default to \code{TRUE}.}

\item{h}{if \code{mat} is of class \code{"snpMatrix"}, band parameter used to
compute the linkage desiquilibrium (see \code{\link[snpStats]{ld}}).}

\item{stats}{if \code{mat} is of class \code{"snpMatrix"}, type of linkage
desiquilibrium measure (see \code{\link[snpStats]{ld}}).}

\item{main}{graphic title.}

\item{col.clust}{color for the borders of the clusters (if \code{clustering}
is provided).}

\item{lwd.clust}{line width for the borders of the clusters (if 
\code{clustering} is provided).}

\item{xaxis}{logical. Should a x-axis be displayed? Default to \code{FALSE}}

\item{naxis}{number of breaks to display on the x-axis. For 
\code{HTCexp} objects, the axis is displayed in terms of Mpb and for the 
other types of input, it is displayed in terms of bin number. Default to 
\code{10}.}
}
\description{
Heatmap of the (dis)similarity matrix
}
\details{
This function produces a heatmap for the used (dis)similarity matrix that 
can be used as a diagnostic plot to check the consistency between the 
obtained clustering and the original (dis)similarity
}
\examples{
# input as HiTC::HTCexp object
\dontrun{
if (require("HiTC", quietly = TRUE)) {
  load(system.file("extdata", "hic_imr90_40_XX.rda", package = "adjclust"))
  plotSim(hic_imr90_40_XX)
  
  # with a constrained clustering
  res <- hicClust(hic_imr90_40_XX, log = TRUE)
  selected.capushe <- select(res)
  plotSim(hic_imr90_40_XX, clustering = selected.capushe, xaxis = TRUE)
  plotSim(hic_imr90_40_XX, clustering = selected.capushe, dendro = res)
}}

plotSim(dist(iris[ ,1:4]), log = FALSE)
}
\seealso{
\code{\link{select}}, \code{\link{adjClust}}
}
