% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pol_yr.R
\name{pol_yr}
\alias{pol_yr}
\alias{pol_qtr}
\alias{pol_mth}
\alias{pol_wk}
\title{Calculate policy duration}
\usage{
pol_yr(x, issue_date)

pol_qtr(x, issue_date)

pol_mth(x, issue_date)

pol_wk(x, issue_date)
}
\arguments{
\item{x}{A vector of dates}

\item{issue_date}{A vector of issue dates}
}
\value{
An integer vector
}
\description{
Given a vector of dates and a vector of issue dates, calculate
policy years, quarters, months, or weeks.
}
\details{
These functions assume the first day of each policy year is the
anniversary date (or issue date in the first year). The last day of each
policy year is the day before the next anniversary date. Analogous rules
are used for policy quarters, policy months, and policy weeks.
}
\examples{
pol_yr(as.Date("2021-02-28") + 0:2, "2020-02-29")

pol_mth(as.Date("2021-02-28") + 0:2, "2020-02-29")

}
