% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveSIM_helper.R
\name{moveSIM_helper}
\alias{moveSIM_helper}
\title{Run model for one replicate}
\usage{
moveSIM_helper(
  sp,
  env,
  days,
  sigma,
  dest_x,
  dest_y,
  mot_x,
  mot_y,
  search_radius,
  optimum,
  n_failures,
  fail_thresh,
  direction,
  single_rast,
  mortality
)
}
\arguments{
\item{sp}{A species object}

\item{env}{Raster, should represent NDVI or your environmental variable of interest}

\item{days}{Integer, how many days (timesteps), would you like to model}

\item{sigma}{Numeric, amount of random error}

\item{dest_x}{Numeric, destination x coordinate (longitude)}

\item{dest_y}{Numeric, destination y coordinate (latitude)}

\item{mot_x}{Numeric, movement motivation in x direction}

\item{mot_y}{Numeric, movement motivation in y direction}

\item{search_radius}{Radius of semicircle to South of current location to search for next timestep (in km)}

\item{mortality}{Logical, should low energy levels result in death? Default T.}
}
\value{
A nx2 dataset containing longitude and latitude points for all n timesteps
}
\description{
Runs agent based modeling for one replicate of a single species. Used by function `generations`
to run more replicates of more species.
}
\keyword{internal}
