% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_maze.R
\name{canvas_maze}
\alias{canvas_maze}
\title{Draw Mazes}
\usage{
canvas_maze(
  color = "#fafafa",
  walls = "black",
  background = "#fafafa",
  resolution = 20,
  polar = FALSE
)
}
\arguments{
\item{color}{a character specifying the color used for the artwork.}

\item{walls}{a character specifying the color used for the walls of the maze.}

\item{background}{a character specifying the color used for the background.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}

\item{polar}{logical, whether to use polar coordinates. Warning, this increases display and saving time dramatically.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws a maze on a canvas.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_maze(color = "#fafafa")
}

}
\references{
\url{https://github.com/matfmc/mazegenerator}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
