% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_polylines.R
\name{canvas_polylines}
\alias{canvas_polylines}
\title{Paint Polygons and Lines on Canvas}
\usage{
canvas_polylines(colors, background = '#fafafa', ratio = 0.5, iterations = 1000, 
                 alpha = NULL, size = 0.1, width = 500, height = 500)
}
\arguments{
\item{colors}{a character (vector) specifying the colors used for the strokes.}

\item{background}{a character specifying the color used for the borders.}

\item{ratio}{width of the polygons. Larger ratios cause more overlap.}

\item{iterations}{the number of points for each polygon.}

\item{alpha}{transparency of the polygons. If \code{NULL}, added layers become increasingly more transparent.}

\item{size}{size of the borders.}

\item{width}{the width of the artwork in pixels.}

\item{height}{the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws many points on the canvas and connects these points into a polygon. After repeating this for all the colors, the edges of all polygons are drawn on top of the artwork.
}
\examples{
\donttest{
set.seed(1)
canvas_polylines(colors = colorPalette('retro2'))
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
