% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGGraph.r
\name{xGGraph}
\alias{xGGraph}
\title{Function to visualise an igraph object using ggraph}
\usage{
xGGraph(
ig,
layout = "partition",
circular = T,
leave = T,
node.label.size = 2,
node.label.direction = c("none", "leftright", "topbottom"),
node.label.color = "steelblue",
node.label.alpha = 0.7,
node.label.wrap = NULL,
node.label.offset = 0.5,
node.size = 2,
limit.expansion = NULL,
edge = c("diagonal", "link", "arc", "fan", "elbow"),
edge.color = "grey",
edge.alpha = 0.5,
edge.width = 0.5,
...
)
}
\arguments{
\item{ig}{an object of class "igraph" with node attribute 'name'. It
could be a 'phylo' object converted to. Note: the node/leave labels
would be the node attribute 'name' unless the node attribute 'label' is
explicitely provided}

\item{layout}{the layout supported in ggraph::create_layout. This can
be ggraph layouts 'partition' (by default), 'dendrogram', 'circlepack',
'treemap' (-1,1). This can be also igraph-supported layout
('nicely','fr','kk','sugiyama','randomly','star','circle','gem','dh','graphopt','grid','mds','drl','lgl','sphere')}

\item{circular}{the logic specifying whether or not circular
representations. This will be disabled implicitly if the layout does
not support circularity}

\item{leave}{the logic specifying whether or not only leaves
(nodes/labellings) shown. This can be disenabled if the layout does not
support tips}

\item{node.label.size}{the text size of the leave labelings. By
default, it is 2. If 0, all labellings will be disabled}

\item{node.label.direction}{the leave label direction. It can be
"none", "leftright" (aligned to the left- and right-most edge) and
"topbottom" (aligned to the top- and bottom-most edge)}

\item{node.label.color}{the color of the leave labelings}

\item{node.label.alpha}{the alpha of the leave labelings}

\item{node.label.wrap}{the wrap width of the leave labelings}

\item{node.label.offset}{the offset of the leave labelings aligned to
the edge. It is defined as relative to the range of limits (x-limit for
left-right, and y-limit for top-bottom)}

\item{node.size}{the size of the leave nodes. By default, it is 0}

\item{limit.expansion}{the x- and y-limit expansion. By default, it is
NULL, decided by "node.label.offset"}

\item{edge}{the edge type. It can be "diagonal" (default) , "link"
(straight lines), "arc", "fan" (curves of different curvature),
"elbow"}

\item{edge.color}{the color of edges}

\item{edge.alpha}{the alpha of edges}

\item{edge.width}{the width of edges}

\item{...}{additional graphic parameters (such as size, color) used in
ggrepel::geom_text_repel to control labels}
}
\value{
a ggplot2 object appended with 'ig' and 'data' which should contain
columns 'x','y','name' (the same as V(ig)$name), 'label' (if not given
in ig, a 'name' varient). Also contain 'leaf' (T/F), 'depth' (the
number of step to the root) for tree-like graph with certain layouts.
}
\description{
\code{xGGraph} is supposed to visualise an igraph object using ggraph,
with nodes/tips labelled (aligned to left-right or top-bottom edges).
}
\note{
none
}
\examples{
\dontrun{
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"

AA.template <- xRDataLoader("AA.template",
RData.location=RData.location)
# consensus tree
ig <- AA.template$consensus$ig

# Default: partition-like circular layout
# none
gp <- xGGraph(ig, node.label.direction="none", node.label.wrap=50)
# leftright
gp <- xGGraph(ig, node.label.direction="leftright", node.label.wrap=50,
node.label.offset=0.5)
# topbottom
gp <- xGGraph(ig, node.label.direction="topbottom", node.label.wrap=50,
node.label.offset=0.5)

# advanced usage
## ggraph layouts
gp <- xGGraph(ig, layout='dendrogram',
node.label.direction="leftright")
gp <- xGGraph(ig, layout='treemap')
gp <- xGGraph(ig, layout='circlepack')
## igraph layouts
set.seed(825)
gp <- xGGraph(ig, layout='nicely', node.label.direction="leftright")
gp <- xGGraph(ig, layout='kk')
gp <- xGGraph(ig, layout='fr', node.label.direction="leftright")
gp <- xGGraph(ig, layout='gem')
}
}
\seealso{
\code{\link{xGGraph}}
}
