% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C2RVine.R
\name{C2RVine}
\alias{C2RVine}
\title{Transform C-Vine to R-Vine Structure}
\usage{
C2RVine(order, family, par, par2 = rep(0, length(family)))
}
\arguments{
\item{order}{A d-dimensional vector specifying the order of the root nodes
in the C-vine.}

\item{family}{A d*(d-1)/2 vector of pair-copula families with values\cr
\code{0} = independence copula \cr \code{1} = Gaussian copula \cr \code{2} =
Student t copula (t-copula) \cr \code{3} = Clayton copula \cr \code{4} =
Gumbel copula \cr \code{5} = Frank copula \cr \code{6} = Joe copula \cr
\code{7} = BB1 copula \cr \code{8} = BB6 copula \cr \code{9} = BB7 copula
\cr \code{10} = BB8 copula \cr \code{13} = rotated Clayton copula (180
degrees; \verb{survival Clayton'') \\cr `14` = rotated Gumbel copula (180 degrees; }survival Gumbel'') \cr \code{16} = rotated Joe copula (180
degrees; \verb{survival Joe'') \\cr `17` = rotated BB1 copula (180 degrees; }survival BB1'')\cr \code{18} = rotated BB6 copula (180 degrees; \verb{survival BB6'')\\cr `19` = rotated BB7 copula (180 degrees; }survival BB7'')\cr
\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr \code{23}
= rotated Clayton copula (90 degrees) \cr `24` = rotated Gumbel copula
(90 degrees) \cr `26` = rotated Joe copula (90 degrees) \cr `27` =
rotated BB1 copula (90 degrees) \cr `28` = rotated BB6 copula (90
degrees) \cr `29` = rotated BB7 copula (90 degrees) \cr `30` =
rotated BB8 copula (90 degrees) \cr `33` = rotated Clayton copula (270
degrees) \cr `34` = rotated Gumbel copula (270 degrees) \cr `36` =
rotated Joe copula (270 degrees) \cr `37` = rotated BB1 copula (270
degrees) \cr `38` = rotated BB6 copula (270 degrees) \cr `39` =
rotated BB7 copula (270 degrees) \cr `40` = rotated BB8 copula (270
degrees) \cr `104` = Tawn type 1 copula \cr `114` = rotated Tawn
type 1 copula (180 degrees) \cr `124` = rotated Tawn type 1 copula (90
degrees) \cr `134` = rotated Tawn type 1 copula (270 degrees) \cr
`204` = Tawn type 2 copula \cr `214` = rotated Tawn type 2 copula
(180 degrees) \cr `224` = rotated Tawn type 2 copula (90 degrees) \cr
`234` = rotated Tawn type 2 copula (270 degrees) \cr}

\item{par}{A d*(d-1)/2 vector of pair-copula parameters.}

\item{par2}{A d*(d-1)/2 vector of second pair-copula parameters (optional;
default:\cr \code{par2 = rep(0,length(family))}), necessary for the t-, BB1,
BB6, BB7, BB8, Tawn type 1 and type 2 copulas.}
}
\value{
An \code{\link[=RVineMatrix]{RVineMatrix()}} object.
}
\description{
This function transforms a C-vine structure from the package CDVine to the
corresponding R-vine structure.
}
\examples{
# set up C-vine copula model with mixed pair-copulas
d <- 4
dd <- d*(d-1)/2
order <- 1:d
family <- c(1, 2, 3, 4, 7, 3)
par <- c(0.5, 0.4, 2, 1.5, 1.2, 1.5)
par2 <- c(0, 5, 0, 0, 2, 0)

# transform to R-vine matrix notation
RVM <- C2RVine(order, family, par, par2)
\donttest{
# load package CDVine for comparison
library(CDVine)

# simulate a sample of size 500 from a 4-dimensional D-vine
type <- 1  # C-vine
simdata <- CDVineSim(500, family, par, par2, type)

# determine log-likelihood
out <- CDVineLogLik(simdata, family, par, par2, type)
out$loglik

# check that log-likelihood stays the same
out2 <- RVineLogLik(simdata, RVM)
out2$loglik
}
}
\seealso{
\code{\link[=RVineMatrix]{RVineMatrix()}}, \code{\link[=D2RVine]{D2RVine()}}
}
\author{
Ulf Schepsmeier, Eike Brechmann
}
