% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_LpS.R
\name{simu_lstsp}
\alias{simu_lstsp}
\title{Function to deploy simulation with LSTSP algorithm}
\usage{
simu_lstsp(
  nreps,
  simu_method = c("LS"),
  nob,
  k,
  lags = 1,
  lags_vector = NULL,
  brk,
  sigma,
  skip = 50,
  group_mats = NULL,
  group_type = c("columnwise", "rowwise"),
  group_index = NULL,
  sparse_mats = NULL,
  sp_density = NULL,
  signals = NULL,
  rank = NULL,
  info_ratio = NULL,
  sp_pattern = c("off-diagonal", "diagoanl", "random"),
  singular_vals = NULL,
  spectral_radius = 0.9,
  alpha_L = 0.25,
  lambda.1 = NULL,
  mu.1 = NULL,
  lambda.1.seq = NULL,
  mu.1.seq = NULL,
  lambda.2,
  mu.2,
  lambda.3,
  mu.3,
  omega = NULL,
  h = NULL,
  step.size = NULL,
  tol = 1e-04,
  niter = 100,
  backtracking = TRUE,
  rolling.skip = 5,
  cv = FALSE,
  nfold = NULL,
  verbose = FALSE
)
}
\arguments{
\item{nreps}{A positive integer, indicating the number of simulation replications}

\item{simu_method}{the structure of time series: only available for "LS"}

\item{nob}{sample size}

\item{k}{dimension of transition matrix}

\item{lags}{lags of VAR time series. Default is 1.}

\item{lags_vector}{a vector of lags of VAR time series for each segment}

\item{brk}{a vector of break points with (nob+1) as the last element}

\item{sigma}{the variance matrix for error term}

\item{skip}{an argument to control the leading data points to obtain a stationary time series}

\item{group_mats}{transition matrix for group sparse case}

\item{group_type}{type for group lasso: "columnwise", "rowwise". Default is "columnwise".}

\item{group_index}{group index for group lasso.}

\item{sparse_mats}{transition matrix for sparse case}

\item{sp_density}{if we choose random pattern, we should provide the sparsity density for each segment}

\item{signals}{manually setting signal for each segment (including sign)}

\item{rank}{if we choose method is low rank plus sparse, we need to provide the ranks for each segment}

\item{info_ratio}{the information ratio leverages the signal strength from low rank and sparse components}

\item{sp_pattern}{a choice of the pattern of sparse component: diagonal, 1-off diagonal, random, custom}

\item{singular_vals}{singular values for the low rank components}

\item{spectral_radius}{to ensure the time series is piecewise stationary.}

\item{alpha_L}{a positive numeric value, indicating the restricted space of low rank component, default is 0.25}

\item{lambda.1}{tuning parameter for sparse component for the first step}

\item{mu.1}{tuning parameter for low rank component for the first step}

\item{lambda.1.seq}{a sequence of lambda to the left segment for cross-validation, it's not mandatory to provide}

\item{mu.1.seq}{a sequence of mu to the left segment, low rank component tuning parameter}

\item{lambda.2}{tuning parameter for sparse for the second step}

\item{mu.2}{tuning parameter for low rank for the second step}

\item{lambda.3}{tuning parameter for estimating sparse components}

\item{mu.3}{tuning parameter for estimating low rank components}

\item{omega}{tuning parameter for information criterion, the larger of omega, the fewer final selected change points}

\item{h}{window size of the first rolling window step}

\item{step.size}{rolling step}

\item{tol}{tolerance for the convergence in the second screening step, indicates when to stop}

\item{niter}{the number of iterations required for FISTA algorithm}

\item{backtracking}{A boolean argument to indicate use backtrack to FISTA model}

\item{rolling.skip}{The number of observations need to skip near the boundaries}

\item{cv}{A boolean argument, indicates whether the user will apply cross validation to select tuning parameter, default is FALSE}

\item{nfold}{An positive integer, the number of folds for cross validation}

\item{verbose}{If is TRUE, then it will print all information about current step.}
}
\value{
A S3 object of class \code{VARDetect.simu.result}, containing the following entries:
\describe{
    \item{sizes}{A 2-d numeric vector, indicating the size of time series data}
    \item{true_lag}{True time lags for the process, here is fixed to be 1.}
    \item{true_lagvector}{A vector recording the time lags for different segments, not available under this model setting,
                          here is fixed to be NULL}
    \item{true_cp}{True change points for simulation, a numeric vector}
    \item{true_sparse}{A list of numeric matrices, indicating the true sparse components for all segments}
    \item{true_lowrank}{A list of numeric matrices, indicating the true low rank components for all segments}
    \item{est_cps}{A list of estimated change points, including all replications}
    \item{est_lag}{A numeric value, estimated time lags, which is user specified}
    \item{est_lagvector}{A vector for estimated time lags, not available for this model, set as NULL.}
    \item{est_sparse_mats}{A list of estimated sparse components for all replications}
    \item{est_lowrank_mats}{A list of estimated low rank components for all replications}
    \item{est_phi_mats}{A list of estimated model parameters, transition matrices for VAR model}
    \item{running_times}{A numeric vector, containing all running times}
}
}
\description{
A function to generate simulation with LSTSP algorithm
}
\examples{
\donttest{
nob <- 100
p <- 15
brk <- c(50, nob+1)
rank <- c(1, 3)
signals <- c(-0.7, 0.8)
singular_vals <- c(1, 0.75, 0.5)
info_ratio <- rep(0.35, 2)
lambda1 = lambda2 = lambda3 <- c(2.5, 2.5)
mu1 = mu2 = mu3 <- c(15, 15)
try_simu <- simu_lstsp(nreps = 3, simu_method = "LS", nob = nob, k = p,
                       brk = brk, sigma = diag(p), signals = signals,
                       rank = rank, singular_vals = singular_vals,
                       info_ratio = info_ratio, sp_pattern = "off-diagonal",
                       spectral_radius = 0.9, lambda.1 = lambda1, mu.1 = mu1,
                       lambda.2 = lambda2, mu.2 = mu2, lambda.3 = lambda3,
                       mu.3 = mu3, step.size = 5, niter = 20, rolling.skip = 5,
                       cv = FALSE, verbose = TRUE)
summary(try_simu, critical = 5)
}
}
