% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GoFComparePool}
\alias{GoFComparePool}
\title{Goodness of fit comparison (for a pooling group)}
\usage{
GoFComparePool(x)
}
\arguments{
\item{x}{a numeric vector (your AMAX sample)}
}
\value{
A list. The first element is a dataframe with four columns and one row of results. Each column has
the standardised RMSE associated with one of the four distributions (GEV, GenLog, Gumbel, Kappa3).
The second element is a character string stating the distribution with the best fit.
}
\description{
compares the RMSE of four distribution fits for a pooling group.
}
\details{
This function calculates an RMSE fit score for four distributions (GEV, GenLog, Gumbel, & Kappa3). The lowest RMSE is the best fit.
It works for pooling groups created using the Pool or PoolSmall function. It uses the same method as GoFCompare (see the associated details of that function).
It first standardises the pooled AMAX samples (by dividing them by median) and then treats them as a single large sample.
Note that this is not a hypothesis test. It is only for comparing the fit across the distributions.
}
\examples{
# Get a pooling group then compare the fit..
Pool60009 <- Pool(GetCDs(60009))
GoFComparePool(Pool60009)
}
\author{
Anthony Hammond
}
