% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCS3functions.R
\name{predict.UComp}
\alias{predict.UComp}
\title{predict.UComp}
\usage{
\method{predict}{UComp}(object, newdata = NULL, n.ahead = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \dQuote{UComp}.}

\item{newdata}{New output data to apply \dQuote{UComp} object to.}

\item{n.ahead}{Number of steps ahead to forecast or new inputs variables 
including their predictions.}

\item{level}{Confidence level for prediction intervals.}

\item{...}{Ignored.}
}
\value{
A matrix with the mean forecasts and lower and upper prediction intervals
}
\description{
Forecasting using structural Unobseved Components models with prediction intervals
}
\details{
See help of \code{UC}.
}
\examples{
\dontrun{
y <- log(AirPassengers)
m1 <- UCforecast(y, model = "llt/eq/arma(0,0)")
f1 <- predict(m1)
}
}
\seealso{
\code{\link{UC}}, \code{\link{UCforecast}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, \code{\link{UCsmooth}}, 
         \code{\link{UCdisturb}}, \code{\link{UCcomponents}}
}
\author{
Diego J. Pedregal
}
