% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{diff_mean_deviance_residuals}
\alias{diff_mean_deviance_residuals}
\title{diff_mean_deviance_residuals}
\usage{
diff_mean_deviance_residuals(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control parameters}
}
\value{
Difference in mean deviance residuals across treatment arms.
}
\description{
Computes the difference in the mean of deviance residuals
function across treatment groups.
}
\details{
The deviance residual is the observed number of
events at time t minus the expected number of events at time t. See
documentation for mean_deviance_residuals (linked below) for more details.
A smaller value for the deviance residual is preferred when the event under
study is an undesirable event -- i.e. it is preferred to observe fewer events
than predicted by the survival model. A two-arm TSDT model computes the mean
deviance residual in the treatment arm minus the mean deviance residual in the
control arm. The treatment arm is superior to the control arm when the mean
deviance residual in the treatment arm is less than the mean deviance residual
in the control arm. Thus, the appropriate value for desirable_response is
desirable_response = 'decreasing'. If the event under study is a desirable
event the appropriate value for desirable_response is desirable_response =
'increasing'. It is assumed most survival models will model an undesirable
event, so the default value for desirable_response when the scoring_function
is diff_mean_deviance_residuals is desirable_response = 'decreasing'. Note
this differs from all other TSDT configurations, for which the default value
for desirable_response is desirable_response = 'increasing'.
}
\seealso{
\link{mean_deviance_residuals}, \link[survival]{Surv},
\link[survival]{coxph}, \link[survival]{survreg},
\link[survival]{residuals.coxph},
\link[survival]{residuals.survreg},
\link{TSDT}
}
