% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_TL.MAAD.R
\name{analyse_TL.MAAD}
\alias{analyse_TL.MAAD}
\title{MAAD protocol for TL dating}
\usage{
analyse_TL.MAAD(object, eval.Tmin, eval.Tmax,
  rejection.criteria = list(testdose.error = 10, paleodose.error = 10),
  fitting.parameters = list(fit.method = "LIN", fit.weighted = FALSE,
  fit.use.slope = FALSE, fit.aDoses.min = 0, fit.aDoses.max = NA, fit.rDoses.min
  = 0, fit.rDoses.max = NA), plotting.parameters = list(plot.Tmin = 0,
  plot.Tmax = NA, no.plot = FALSE))
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the TL curves used for the ED estimation.}

\item{eval.Tmin}{\link{integer} (\bold{required}): Temperature ( °C) of the lower boundary for the signal integration.}

\item{eval.Tmax}{\link{integer} (\bold{required}): Temperature ( °C) of the upper boundary for the signal integration.}

\item{rejection.criteria}{\link{list} (with default): list containing the rejection criteria (in \%). See details.}

\item{fitting.parameters}{\link{list} (with default): list containing the fitting parameters. See details.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\value{
The results are plotted using \link{plot_TL.MAAD}. \cr

 The function also provides a \linkS4class{TLum.Results} containing: \cr
 \describe{
   \item{\code{De.GC}}{
     \link{list}: Results obtained with the dose plateau approach and their uncertainties
     (\code{De}, \code{De.error}, \code{Q}, \code{Q.error}, \code{I}, \code{I.error})}
   \item{\code{De.DP}}{
     \link{list}: Results obtained with the growth curve approach and their uncertainties
     (\code{De}, \code{De.error}, \code{Q}, \code{Q.error}, \code{I}, \code{I.error})}
   \item{\code{LnLxTnTx.table}}{
     \link{matrix}: Lx/Tx values}
   \item{\code{RC.Status}}{
   \link{character}: The acceptance result. }
 }
}
\description{
Function to estimate the ED in TL dating using the MAAD protocol. \cr
It provides an estimation of the palaeodose (Q) and/or the supralinearity correction (I).
The equivalent dose (ED) is estimated by the addition of Q and I. \cr
See details for more information.
}
\details{
This function estimates the equivalent dose for the thermoluminescence dating with the MAAD protocol.
It can provide an estimation of the palaeodose (Q) and the supralinearity correction (I) simultaniously or separately.
These are estimated using the growth curve approach (QC) (Aitken, 1985) and the dose plateau approach (DP).
Both approaches should provide a similar result. The equivalent dose is estimated by the addition of Q and I\cr
The Lx/Tx matrix is estimated using \link{calc_TL.LxTx}. \cr
The average TL curves for each dose step are estimate using \link{calc_TL.MAAD.average}. \cr
The plateau test values are estimated using \link{calc_TL.plateau}. \cr

\bold{Rejection criteria} \cr
The rejection criteria are: \cr
\describe{
 \item{\code{testdose.error}}{
   \link{numeric}: Maximum error accepted on Tx (in \%).}
 \item{\code{paleodose.error}}{
   \link{numeric}: Maximum error accepted on Lx (in \%).}
 }

\bold{Fitting parameters} \cr
The fitting parameters are:  \cr
\describe{
 \item{\code{method}}{
   \link{character}: Fitting method (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).}
 \item{\code{fit.weighted}}{
   \link{logical}: If the fitting is weighted or not.}
 \item{\code{fit.use.slope}}{
   \link{logical}: If the slope of the Q growth curve is reused for the supralinearity correction.}
 \item{\code{fit.aDoses.min}}{
   \link{numeric}: Lowest additive dose used for the fitting.}
 \item{\code{fit.aDoses.max}}{
   \link{numeric}: Highest additive dose used for the fitting.}
 \item{\code{fit.rDoses.min}}{
   \link{numeric}: Lowest regenerative dose used for the fitting.}
 \item{\code{fit.rDoses.max}}{
   \link{numeric}: Highest regenerative dose used for the fitting.}
}
See also \link{calc_TL.MAAD.fit.Q} and \link{calc_TL.MAAD.fit.I}. \cr

\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lowest temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: Highest temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{plot_TL.MAAD}. \cr
}
\examples{

##load data

##perform analysis

}
\author{
David Strebler, University of Cologne (Germany)
}
\references{
Aitken, M.J. (1985) Thermoluminescence Dating, Academic Press, London \cr
}
\seealso{
\link{calc_TL.LxTx},
 \link{calc_TL.plateau},
 \link{calc_TL.MAAD.average},
 \link{calc_TL.MAAD.separate},
 \link{calc_TL.MAAD.fit.I},
 \link{calc_TL.MAAD.fit.Q},
 \link{analyse_TL.SAR}.
}

