% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing_functions.R
\name{plotDensitySplitByCustom}
\alias{plotDensitySplitByCustom}
\title{Plot Density Graph, Splitting Groups by Custom Label}
\usage{
plotDensitySplitByCustom(
  data_path,
  graph_title = "Call Distribution, Split by Custom Category Labels",
  graph_subtitle = "Calls are split by custom labels designated in DeepSqueak.",
  chosen_group = c()
)
}
\arguments{
\item{data_path}{The full path to the Excel file exported from DeepSqueak}

\item{graph_title}{The title for the graph (there is a default title if not specified)}

\item{graph_subtitle}{The subtitle for the graph (there is a default subtitle if not specified)}

\item{chosen_group}{Specifying a particular group to be highlighted in the graph}
}
\value{
A ggplot2 visualization of the density graph shown in the viewer window, which can be manually exported.
}
\description{
Plots a density graph, separating each custom label group into a separate plot in the figure.
}
\examples{
\dontrun{plotDensitySplitByCustom(
  data_path = "inst/extdata/Example_Mouse_Data.xlsx",
  graph_title = "myTitle", graph_subtitle = "myDescription"
)}

}
