% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{events}
\alias{events}
\alias{simList-accessors-events}
\alias{events,simList,character-method}
\alias{events,simList,missing-method}
\alias{events<-}
\alias{events<-,simList-method}
\alias{conditionalEvents}
\alias{conditionalEvents,simList,character-method}
\alias{conditionalEvents,simList,missing-method}
\alias{current}
\alias{current,simList,character-method}
\alias{current,simList,missing-method}
\alias{current<-}
\alias{current<-,simList-method}
\alias{completed}
\alias{completed,simList,character-method}
\alias{completed,simList,missing-method}
\alias{completed<-}
\alias{completed<-,simList-method}
\title{Simulation event lists}
\usage{
events(sim, unit)

\S4method{events}{simList,character}(sim, unit)

\S4method{events}{simList,missing}(sim, unit)

events(sim) <- value

\S4method{events}{simList}(sim) <- value

conditionalEvents(sim, unit)

\S4method{conditionalEvents}{simList,character}(sim, unit)

\S4method{conditionalEvents}{simList,missing}(sim, unit)

current(sim, unit)

\S4method{current}{simList,character}(sim, unit)

\S4method{current}{simList,missing}(sim, unit)

current(sim) <- value

\S4method{current}{simList}(sim) <- value

completed(sim, unit, times = TRUE)

\S4method{completed}{simList,character}(sim, unit, times = TRUE)

\S4method{completed}{simList,missing}(sim, unit, times = TRUE)

completed(sim) <- value

\S4method{completed}{simList}(sim) <- value
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or in which to replace element(s).}

\item{unit}{Character. One of the time units used in \code{SpaDES}.}

\item{value}{The object to be stored at the slot.}

\item{times}{Logical. Should this function report the \code{clockTime}.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{events} and \code{completed} slots of a
\code{simList} object. These path functions will extract the values that were
provided to the \code{simInit} function in the \code{path} argument.
}
\details{
By default, the event lists are shown when the \code{simList} object is printed,
thus most users will not require direct use of these methods.
\tabular{ll}{
\code{events} \tab Scheduled simulation events (the event queue).\cr
\code{completed} \tab Completed simulation events.\cr
}

Currently, only get and set methods are defined. Subset methods are not.
}
\note{
Each event is represented by a \code{\link[=data.table]{data.table()}} row consisting of:
\itemize{
\item \code{eventTime}: The time the event is to occur.
\item \code{moduleName}: The module from which the event is taken.
\item \code{eventType}: A character string for the programmer-defined event type.
}
}
\seealso{
\link{SpaDES.core-package}, specifically the section 1.2.6 on Simulation event queues.

Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{checkpointFile}()},
\code{\link{envir}()},
\code{\link{globals}()},
\code{\link{inputs}()},
\code{\link{modules}()},
\code{\link{objs}()},
\code{\link{packages}()},
\code{\link{params}()},
\code{\link{paths}()},
\code{\link{progressInterval}()},
\code{\link{times}()}
}
\concept{functions to access elements of a 'simList' object}
