% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.R
\docType{data}
\name{inSeconds}
\alias{inSeconds}
\alias{convertTimeunit}
\alias{.spadesTimes}
\alias{spadesTimes}
\alias{checkTimeunit}
\alias{checkTimeunit,character,missing-method}
\alias{checkTimeunit,character,environment-method}
\title{Convert time units}
\format{
An object of class \code{character} of length 12.
}
\usage{
inSeconds(unit, envir, skipChecks = FALSE)

convertTimeunit(time, unit, envir, skipChecks = FALSE)

.spadesTimes

spadesTimes()

checkTimeunit(unit, envir)

\S4method{checkTimeunit}{character,missing}(unit, envir)

\S4method{checkTimeunit}{character,environment}(unit, envir)
}
\arguments{
\item{unit}{Character. One of the time units used in \code{SpaDES} or user
defined time unit, given as the unit name only. See details.}

\item{envir}{An environment. This is where to look up the function definition for
the time unit. See details.}

\item{skipChecks}{For speed, the internal checks for classes and missingness can be skipped.
Default \code{FALSE}.}

\item{time}{Numeric. With a unit attribute, indicating the time unit of the
input numeric. See Details.}
}
\value{
A numeric vector of length 1, with \code{unit} attribute set to "seconds".
}
\description{
Current pre-defined units are found within the \code{spadesTimes()} function.
The user can define a new unit.
The unit name can be anything, but the function definition must be of the
form \code{"dunitName"}, e.g., \code{dyear} or \code{dfortnight}.
The unit name is the part without the \code{d} and the function name
definition includes the \code{d}.
This new function, e.g., \code{dfortnight <- function(x) lubridate::duration(dday(14))}
can be placed anywhere in the search path or in a module
(you will need to declare \code{"lubridate"} in your \code{pkgDeps} in the metadata).

This function takes a numeric with a "unit" attribute and converts it to
another numeric with a different time attribute.
If the units passed to argument \code{units} are the same as
\code{attr(time, "unit")}, then it simply returns input \code{time}.
}
\details{
Because of R scoping, if \code{envir} is a \code{simList} environment, then
this function will search there first, then up the current \code{search()} path.
Thus, it will find a user defined or module defined unit before a SpaDES unit.
This means that a user can override the \code{dyear} given in SpaDES, for example,
which is 365.25 days, with \code{dyear <- function(x) lubridate::duration(dday(365))}.

If \code{time} has no \code{unit} attribute, then it is assumed to be
seconds.
}
\author{
Alex Chubaty & Eliot McIntire

Eliot McIntire
}
\keyword{datasets}
