% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-spades.R
\name{doEvent}
\alias{doEvent}
\title{Process a simulation event}
\usage{
doEvent(sim, debug = FALSE, notOlderThan)
}
\arguments{
\item{sim}{Character string for the \code{simList} simulation object.}

\item{debug}{Optional tools for invoking debugging. Supplying a \code{list}
will invoke the more powerful \code{logging} package. See details.
Default is to use the value in \code{getOption("spades.debug")}.}

\item{notOlderThan}{Date or time. Passed to \code{reproducible::Cache} to update the cache.
Default is \code{NULL}, meaning don't update the cache.
If \code{Sys.time()} is provided, then it will force a recache,
i.e., remove old value and replace with new value.
Ignored if \code{cache} is \code{FALSE}.}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Internal function called from \code{spades}.
}
\details{
Calls the module corresponding to the event call, and executes the event.

Here, we implement a simulation in a more modular fashion so it's easier to add
submodules to the simulation. We use S4 classes and methods.
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3).
            San Francisco, CA: No Starch Press, Inc..
            Retrieved from \url{https://www.nostarch.com/artofr.htm}
}
\author{
Alex Chubaty
}
\keyword{internal}
