% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{times}
\alias{times}
\alias{simList-accessors-times}
\alias{times,simList-method}
\alias{times<-}
\alias{times<-,simList-method}
\alias{time.simList}
\alias{time<-}
\alias{time<-,simList-method}
\alias{end}
\alias{end.simList}
\alias{end<-}
\alias{end<-,simList-method}
\alias{start}
\alias{start.simList}
\alias{start<-}
\alias{start<-,simList-method}
\alias{timeunit}
\alias{timeunit,simList-method}
\alias{timeunit<-}
\alias{timeunit<-,simList-method}
\alias{timeunits}
\alias{timeunits,simList-method}
\alias{elapsedTime}
\alias{elapsedTime.simList}
\title{Time usage in \code{SpaDES}}
\usage{
times(x, ...)

\S4method{times}{simList}(x)

times(x) <- value

\S4method{times}{simList}(x) <- value

\method{time}{simList}(x, unit, ...)

time(x) <- value

\S4method{time}{simList}(x) <- value

end(x, ...)

\method{end}{simList}(x, unit, ...)

end(x) <- value

\S4method{end}{simList}(x) <- value

start(x, ...)

\method{start}{simList}(x, unit = NULL, ...)

start(x) <- value

\S4method{start}{simList}(x) <- value

timeunit(x)

\S4method{timeunit}{simList}(x)

timeunit(x) <- value

\S4method{timeunit}{simList}(x) <- value

timeunits(x)

\S4method{timeunits}{simList}(x)

elapsedTime(x, ...)

\method{elapsedTime}{simList}(x, byEvent = TRUE, ...)
}
\arguments{
\item{x}{A \code{simList}}

\item{...}{Additional parameters.}

\item{value}{A time, given as a numeric, optionally with a unit attribute,
but this will be deduced from the model time units or module
time units (if used within a module).}

\item{unit}{Character. One of the time units used in \code{SpaDES}.}

\item{byEvent}{Logical. If \code{TRUE}, the elapsed time will be by module and event;
\code{FALSE} will report only by module. Default is \code{TRUE}.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Functions for the \code{simtimes} slot of a \code{simList} object
and its elements. To maintain modularity, the behaviour of these functions depends
on where they are used. In other words, different modules can have their own
timeunit. \code{SpaDES} converts these to seconds when running a simulation, but
shows the user time in the units of the model as shown with \code{timeunit(sim)}
}
\details{
\code{timeunit} will extract the current units of the time used in a
simulation (i.e., within a \code{spades} call).
If it is set within a \code{simInit}, e.g.,
\code{times=list(start=0, end=52, timeunit = "week")}, it will set the
units for that simulation.
By default, a \code{simInit} call will use the smallest unit contained within
the metadata for the modules being used. If there are parent modules, then the
parent module timeunit will be used even if one of its children is a smaller timeunit.
If all modules, including parents, are set to \code{NA}, \code{timeunit} defaults to seconds.
If parents are set to \code{NA}, then the set of modules defined by that parent module
will be given the smallest units of the children.

Currently, available units are "second", "hours", day", "week", "month", and
"year" can be used in the metadata of a module.

The user can also define a new unit. The unit name can be anything, but the
function definition must be of the form \code{dunitName}, e.g., \code{dyear}
or \code{dfortnight}.
The unit name is the part without the \code{d} and the function name definition
includes the \code{d}. This new function, e.g.,
\code{dfortnight <- function(x) lubridate::duration(dday(14))}
can be placed anywhere in the search path or in a module.

\code{timeunits} will extract the current units of the time of all
modules used in a simulation.
This is different from \code{timeunit} because it is not necessarily
associated with a \code{spades} call.

In many cases, the "simpler" use of each of these functions may be slower
computationally. For instance, it is much faster to use \code{time(sim, "year")}
than \code{time(sim)}. So as a module developer, it is advantageous to
write out the longer one, minimizing the looking up that R must do.
}
\note{
These have default behaviour that is based on the calling frame timeunit.
When used inside a module, then the time is in the units of the module.
If used in an interactive mode, then the time will be in the units of the
simulation.

Additional methods are provided to access the current, start, and end times
of the simulation:

\tabular{ll}{
   \code{time} \tab Current simulation time.\cr
   \code{start} \tab Simulation start time.\cr
   \code{end} \tab Simulation end time.\cr
   \code{timeunit} \tab Simulation timeunit.\cr
   \code{timeunits} \tab Module timeunits.\cr
   \code{times} \tab List of all simulation times (current, start, end, timeunit).\cr
}
}
\seealso{
\code{\link{SpaDES.core-package}}, specifically the section 1.2.5 on Simulation times.

Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{doEvent.checkpoint}()},
\code{\link{envir}()},
\code{\link{events}()},
\code{\link{globals}()},
\code{\link{inputs}()},
\code{\link{modules}()},
\code{\link{objs}()},
\code{\link{packages}()},
\code{\link{params}()},
\code{\link{paths}()},
\code{\link{progressInterval}()}
}
\author{
Alex Chubaty and Eliot McIntire
}
\concept{functions to access elements of a 'simList' object}
