% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\docType{methods}
\name{Plot,simList-method}
\alias{Plot,simList-method}
\title{Plot method for \code{simList} objects}
\usage{
\S4method{Plot}{simList}(..., new = FALSE, addTo = NULL, gp = gpar(),
  gpText = gpar(), gpAxis = gpar(), axes = FALSE, speedup = 1,
  size = 5, cols = NULL, col = NULL, zoomExtent = NULL,
  visualSqueeze = NULL, legend = TRUE, legendRange = NULL,
  legendText = NULL, pch = 19, title = TRUE, na.color = "#FFFFFF00",
  zero.color = NULL, length = NULL, arr = NULL, plotFn = "plot")
}
\arguments{
\item{...}{A combination of \code{spatialObjects} or non-spatial objects.
For many object classes, there are specific \code{Plot} methods. Where
there are no specific ones, the base plotting will be used internally.
This means that for objects with no specific \code{Plot} methods,
many arguments, such as \code{addTo}, will not work.
See details.}

\item{new}{Logical. If \code{TRUE}, then the previous named plot area is wiped
and a new one made; if \code{FALSE}, then the \code{...} plots will be
added to the current device, adding or rearranging the plot layout
as necessary. Default is \code{FALSE}. This currently works best if
there is only one object being plotted in a given Plot call. However,
it is possible to pass a list of logicals to this, matching the
length of the ... objects. Use \code{clearPlot} to clear the whole
plotting device.}

\item{addTo}{Character vector, with same length as \code{...}.
This is for overplotting, when the overplot is not to occur on
the plot with the same name, such as plotting a
\code{SpatialPoints*} object on a \code{RasterLayer}.}

\item{gp}{A \code{gpar} object, created by \code{\link{gpar}} function,
to change plotting parameters (see \pkg{grid} package).}

\item{gpText}{A \code{gpar} object for the title text.
Default \code{gpar(col = "black")}.}

\item{gpAxis}{A \code{gpar} object for the axes.
Default \code{gpar(col = "black")}.}

\item{axes}{Logical or \code{"L"}, representing the left and bottom axes,
over all plots.}

\item{speedup}{Numeric. The factor by which the number of pixels is divided
by to plot rasters. See Details.}

\item{size}{Numeric. The size, in points, for \code{SpatialPoints} symbols,
if using a scalable symbol.}

\item{cols}{(also \code{col}) Character vector or list of character vectors of colours.
See details.}

\item{col}{(also \code{cols}) Alternative to \code{cols} to be consistent with \code{plot}.
\code{cols} takes precedence, if both are provided.}

\item{zoomExtent}{An \code{Extent} object. Supplying a single extent that is
smaller than the rasters will call a crop statement before
plotting. Defaults to \code{NULL}.
This occurs after any downsampling of rasters, so it may
produce very pixelated maps.}

\item{visualSqueeze}{Numeric. The proportion of the white space to be used
for plots. Default is 0.75.}

\item{legend}{Logical indicating whether a legend should be drawn.
Default is \code{TRUE}.}

\item{legendRange}{Numeric vector giving values that, representing the lower
and upper bounds of a legend (i.e., \code{1:10} or
\code{c(1,10)} will give same result) that will override
the data bounds contained within the \code{grobToPlot}.}

\item{legendText}{Character vector of legend value labels.
Defaults to \code{NULL}, which results in a pretty numeric
representation.
If \code{Raster*} has a Raster Attribute Table (\code{rat};
see \pkg{raster} package), this will be used by default.
Currently, only a single vector is accepted.
The length of this must match the length of the legend, so
this is mostly useful for discrete-valued rasters.}

\item{pch}{see \code{?par}.}

\item{title}{Logical or character string. If logical, it
indicates whether to print the object name as the title
above the plot. If a character string, it will print this
above the plot. NOTE: the object name is used with \code{addTo},
not the title.}

\item{na.color}{Character string indicating the color for \code{NA} values.
Default transparent.}

\item{zero.color}{Character string indicating the color for zero values,
when zero is the minimum value, otherwise, zero is
treated as any other color. Default transparent.}

\item{length}{Numeric. Optional length, in inches, of the arrow head.}

\item{arr}{A vector of length 2 indicating a desired arrangement of plot
areas indicating number of rows, number of columns.
Default NULL, meaning
let Plot function do it automatically.}

\item{plotFn}{An optional function name to do the plotting internally, e.g.,
"barplot" to get a barplot() call. Default "plot".}
}
\description{
Extends \code{\link[quickPlot]{Plot}} for \code{simList} objects.
}
\details{
Plot for simList class objects

See \code{\link[quickPlot]{Plot}}. This method strips out stuff
from a simList class object that would make it otherwise not
reproducibly digestible between sessions, operating systems,
or machines. This will likely still not allow identical digest
results across R versions.
}
\seealso{
\code{\link[quickPlot]{Plot}}
}
