% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.evol.enz.one.R
\name{simul.evol.enz.one}
\alias{simul.evol.enz.one}
\title{Simulation of enzyme evolution}
\usage{
simul.evol.enz.one(E_ini_fun, kin_fun, Keq_fun, N_fun, correl_fun, 
beta_fun=NULL, X_fun=1, pasobs=250, npt=500, max_mut_size_E=1, max_mut_size_A=1,
pmutA=0, typ_E=1, typ_A=1, use.old.mut=FALSE)
}
\arguments{
\item{E_ini_fun}{Numeric vector of the initial concentrations}

\item{kin_fun}{Numeric vector of the initial kinetic parameters}

\item{Keq_fun}{Numeric vector of equilibrium constants}

\item{N_fun}{Numeric. Population size}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{X_fun}{Numeric. Numerator of function \code{\link{flux}}. Default is 1}

\item{pasobs}{Numeric. Number of time steps between two successive observations of the system. Default is \code{250}}

\item{npt}{Numeric. Number of observations. Default is \code{500}}

\item{max_mut_size_E}{Numeric. Maximum absolute size of mutation for enzyme concentrations. Default is 1}

\item{max_mut_size_A}{Numeric. Maximum absolute size of mutation for kinetic parameters. Default is 1}

\item{pmutA}{Numeric. Mutation probability of kinetic parameters.
Higher \code{pmutA}, higher the mutation probability of kinetic parameters compared to enzyme concentrations.
Default is 0, i.e. no mutation of kinetic parameters}

\item{typ_E}{Numeric for mutation method. Authorized values: 1 or 2. Default is 1.}

\item{typ_A}{Numeric for mutation method. Default is 1. \emph{See details in \code{\link{mut.kin}}.}}

\item{use.old.mut}{Logical. If \code{FALSE} (default), use \code{\link{mut.E.direct}} mutation method, else use \code{\link{mut.E.old}} mutation method if \code{TRUE}}
}
\value{
Invisible list of 4 elements:
\itemize{
   \item \code{$res_sim}: numeric matrix of \code{npt} rows and \code{3*n+3} columns.
   Each row corresponds to state at each observation step (i.e. after \code{pasobs} mutations),
   and columns are respectively concentrations (\code{1:n}), kinetic parameters (\code{n+1:2n}), total concentration (\code{2n+1}), total kinetic (\code{2n+2}), flux/fitness (\code{2n+3}), activities (\code{2n+4:3n+3});
   \item \code{$pred_enzsim}: numeric matrix of \code{npt} rows and \code{n} columns, corresponding to relative concentrations at equilibrium, for each observation step (in rows);
   \item \code{$pred_contsim}: same as \code{$pred_enzsim}, but for response coefficients
   \item \code{$param}: list of input parameters: \itemize{
       \item \code{n}: number of enzymes,
       \item \code{E0}: numeric vector of initial concentrations,
       \item \code{kin}: numeric vector of initial kinetic parameters,
       \item \code{Keq}: numeric vector of constant equilibrium,
       \item \code{beta}: matrix of co-regulation coefficients,
       \item \code{B}: numeric vector of global co-regulation coefficients,
       \item \code{correl}: character string indicating the constraint abbreviation,
       \item \code{N}: population size,
       \item \code{pasobs}: number of steps between two system observations,
       \item \code{npt}: number of system observations,
       \item \code{X}: parameter for flux computation,
       \item \code{pmutA}: probability for activity mutation,
       \item other input parameters}
}

Note that \code{n} is the number of enzymes, which is the length of \code{E_ini_fun}.
}
\description{
This function simulates evolution of enzyme concentrations under constraints
}
\details{
Time step is defined between appearance of two mutation.

Time step is simulated with function \code{\link{simul.next.resident}}, which gives values of resident after a time step.

To reduce size of result matrix, certain results only are conserved.
State of simulation is observed every \code{pasobs} time steps.
There is \code{npt} observations, so result matrix has \code{npt} rows.
In total, a simulation includes \code{pasobs*npt} time steps. By default, there is \code{125 000} time steps.

Chosen equilibrium for \code{pred_enzsim} and \code{pred_contsim} are the theoretical equilibrium for constraints \code{"SC"}, \code{"Comp"} and \code{"RegPos"}, 
and the effective one for constraints \code{"RegNeg"}, \code{"CRPos"} and \code{"CRNeg"}. If there is regulation groups (\code{sum(1/B)>1}), the the theoretical equilibrium \emph{within groups} is given.
}
\seealso{
See function \code{\link{simul.next.resident}} to see how works each time steps. 

Use function \code{\link{simul.evol.enz.multiple}} to compute several simulations.
}
