\name{carto}
\alias{carto}

\title{Preference Mapping Techniques}

\description{
Performs preference mapping techniques based on multidimensional exploratory data analysis.
}

\usage{
carto(Mat, MatH, option = c("pca", "manual","afmult", "statis", "gpa"), level = 0, regmod = 1, graphic = FALSE, coord = c(1, 2), asp = 1, cex = 1.3, col = "steelblue4", font = 2, clabel = 0.8, label.j = FALSE,resolution=200,nb.clusters=0)
}

\arguments{

\item{Mat}{a data frame or an object of class \code{ktab} (i.e. a list of data frames with the same row.names in common).
If "pca" or "manual" are assigned to the \code{option} parameter, then Mat must be a data frame, otherwise
Mat is an object of class \code{ktab}}
\item{MatH}{a data frame in which each row represent a product and each column represent the hedonic scores of a given 
consumer for the products}
\item{option}{the multidimensional exploratory data analysis to be performed, e.g. Principal Components 
Analysis (\code{"pca"}), Multiple Factor Analysis (\code{"afmult"}), 
Statis method (\code{"statis"}), Generalised Procrustes Analysis (\code{"gpa"}); or two axis calculated
separatly (\code{"manual"})}
\item{level}{the number of standard deviations used in the calculation of the preference response surface for all
the consumers}
\item{regmod}{the type of regression model used in the calculation of the preference response surface for all
the consumers. \code{regmod} = 1: quadratic model, 
\code{regmod} = 2: vector model, \code{regmod} = 3: circular model, \code{regmod} = 4: elliptical model}
\item{graphic}{if \code{TRUE} is assigned to that parameter, each graphic displayed is output in a specific window}
\item{coord}{a vector of length 2, the rank of the axis used to display the results if \code{"manual"}
is not assigned to the \code{option} parameter}
\item{asp}{if 1 is assigned to that parameter, the graphic displays are output in an orthonormal coordinate system}
\item{cex}{cf. function \code{\link{par}} in the \pkg{graphics} package}
\item{col}{cf. function \code{\link{par}} in the \pkg{graphics} package}
\item{font}{cf. function \code{\link{par}} in the \pkg{graphics} package}
\item{clabel}{cf. the \pkg{ade4} package}
\item{label.j}{boolean, if T then the labels of the panelists who gave the hedonic scores are displayed}
\item{resolution}{resolution of the map}
\item{nb.clusters}{number of clusters to use (by default, 0 and the optimal numer of clusters is calculated}
}

\details{
The preference mapping methods are commonly used in the fields of market research 
and research and development to explore and understand the structure and tendencies of consumer preferences, 
to link consumer preference information to other data and to predict the behavior of consumers 
in terms of acceptance of a given product.\cr
This function refers to the method introduced by M. Danzart. A response surface is computed per consumer; then
according to certain threshold preference zones are delimited and finally superimposed.

}
\references{

Danzart M., Sieffermann J.M., Delarue J. (2004). New developments in preference mapping techniques: 
finding out a consumer optimal product, its sensory profile and the key sensory attributes. 
\emph{7th Sensometrics Conference, July 27-30, 2004, Davis, CA.}\cr

}

\author{
Franois Husson \email{Franois.Husson@agrocampus-rennes.fr} \cr
Sbastien L \email{Sebastien.Le@agrocampus-rennes.fr}
}

\seealso{\code{\link{afmult}}, \code{\link{gpa}}}

\examples{
\dontrun{
## Example 1
data(chocolates)
data(hedochoc)
chocselect <- search.desc(chocolates,col.j=1,col.p=4,firstvar=5)
resaveragetable<-averagetable(chocselect,formul="~Product",firstvar=5)
carto(resaveragetable, hedochoc, option = "pca")

## Example 2
data(sensopanels)
data(hedochoc)
ktabsenso <- ktab.data.frame(sensopanels, blocks = rep(14,7))
carto(ktabsenso,hedochoc,option = "afmult", graphic = TRUE)
}
}

\keyword{multivariate}
\keyword{models}
