% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluralize.R
\name{pluralize}
\alias{pluralize}
\title{Converts Words to their Plural Form}
\usage{
pluralize(word)
}
\arguments{
\item{word}{A word}
}
\value{
Returns the word in singular form
}
\description{
A function to change words to their plural form.
The rules for converting words to their plural forms
are based on the grammar rules found here:
\href{https://www.grammarly.com/blog/plural-nouns/}{https://www.grammarly.com/blog/plural-nouns/}.
This function does not handle special cases, so particular care is necessary.
}
\examples{
# Handles any prototypical cases
"dogs"
pluralize("dog")

"foxes"
pluralize("fox")

"wolves"
pluralize("wolf")

"octopi"
pluralize("octopus")

"taxa"
pluralize("taxon")

# And most special cases:
"wives"
pluralize("wife")

"roofs"
pluralize("roof")

"photos"
pluralize("photo")

# And some irregular cases:
"children"
pluralize("child")

"teeth"
pluralize("tooth")

"mice"
pluralize("mouse")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
