% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemes.R
\name{set_and_reps_schemes}
\alias{set_and_reps_schemes}
\alias{scheme_generic}
\alias{scheme_wave}
\alias{scheme_plateau}
\alias{scheme_step}
\alias{scheme_step_reverse}
\alias{scheme_wave_descending}
\alias{scheme_light_heavy}
\alias{scheme_pyramid}
\alias{scheme_pyramid_reverse}
\alias{scheme_rep_acc}
\title{Set and Rep Schemes}
\usage{
scheme_generic(
  reps = c(5, 5, 5),
  adjustment = c(0, 0, 0),
  vertical_planning = vertical_linear,
  vertical_planning_control = list(),
  progression_table = progression_RIR_increment,
  progression_table_control = list()
)

scheme_wave(
  reps = c(10, 8, 6, 10, 8, 6),
  adjustment = c(4, 2, 0, 6, 4, 2),
  vertical_planning = vertical_linear,
  vertical_planning_control = list(),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

scheme_plateau(
  reps = c(5, 5, 5, 5),
  vertical_planning = vertical_constant,
  vertical_planning_control = list(),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

scheme_step(
  reps = c(5, 5, 5, 5),
  adjustment = c(-0.3, -0.2, -0.1, 0),
  vertical_planning = vertical_constant,
  vertical_planning_control = list(),
  progression_table = progression_perc_drop,
  progression_table_control = list(volume = "normal")
)

scheme_step_reverse(
  reps = c(10, 10, 10, 10),
  adjustment = c(0, 3, 6, 9),
  vertical_planning = vertical_constant,
  vertical_planning_control = list(),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "normal")
)

scheme_wave_descending(
  reps = c(6, 8, 10, 6, 8, 10),
  adjustment = c(4, 2, 0, 6, 4, 2),
  vertical_planning = vertical_linear,
  vertical_planning_control = list(),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

scheme_light_heavy(
  reps = c(6, 3, 6, 3, 6, 3),
  adjustment = c(0, -0.2, 0, -0.2, 0, -0.2),
  vertical_planning = vertical_constant,
  vertical_planning_control = list(),
  progression_table = progression_perc_drop,
  progression_table_control = list(volume = "normal")
)

scheme_pyramid(
  reps = c(12, 10, 8, 8, 10, 12),
  adjustment = 0,
  vertical_planning = vertical_linear,
  vertical_planning_control = list(reps_change = c(0, -2, -4, -6)),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

scheme_pyramid_reverse(
  reps = c(8, 10, 12, 12, 10, 8),
  adjustment = 0,
  vertical_planning = vertical_linear,
  vertical_planning_control = list(reps_change = c(0, -2, -4, -6)),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

scheme_rep_acc(
  reps = c(7, 7, 7),
  adjustment = 0,
  vertical_planning_control = list(step = rep(-3, 4)),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)
}
\arguments{
\item{reps}{Numeric vector indicating reps prescription}

\item{adjustment}{Numeric vector indicating adjustments. Forwarded to \code{progression_table}.
If the \code{progression_table} is \code{\link{progression_RIR_increment}}, \code{adjustment} will be done
using RIR. On the other hand, if \code{\link{progression_perc_drop}} is used, \code{adjustment} will be done
using 1RM percentage}

\item{vertical_planning}{Vertical planning function. Default is \code{\link{vertical_linear}}}

\item{vertical_planning_control}{Arguments forwarded to the \code{vertical_planning} function}

\item{progression_table}{Progression table function. Default is \code{\link{progression_RIR_increment}}}

\item{progression_table_control}{Arguments forwarded to the \code{progression_table} function}
}
\value{
Data frame with the following columns: \code{reps}, \code{index}, \code{step},
\code{adjustment}, and \code{perc_1RM}.
}
\description{
Set and Rep Schemes
}
\section{Functions}{
\itemize{
\item \code{scheme_generic}: Generic set and rep scheme.
\code{scheme_generic} is called in all other set and rep schemes - only the default parameters
differ to make easier and quicker schemes writing and groupings

\item \code{scheme_wave}: Wave set and rep scheme

\item \code{scheme_plateau}: Plateau set and rep scheme

\item \code{scheme_step}: Step set and rep scheme

\item \code{scheme_step_reverse}: Reverse Step set and rep scheme

\item \code{scheme_wave_descending}: Descending Wave set and rep scheme

\item \code{scheme_light_heavy}: Light-Heavy set and rep scheme

\item \code{scheme_pyramid}: Pyramid set and rep scheme

\item \code{scheme_pyramid_reverse}: Reverse Pyramid set and rep scheme

\item \code{scheme_rep_acc}: Rep Accumulation set and rep scheme
}}

\examples{
scheme_generic()

# Wave set and rep schemes
--------------------------
  scheme_wave()

scheme_wave(
  reps = c(8, 6, 4, 8, 6, 4),
  vertical_planning = vertical_block,
  progression_table = progression_perc_drop,
  progression_table_control = list(type = "ballistic")
)

# Adjusted second wave
# and using 3 steps progression
scheme_wave(
  reps = c(8, 6, 4, 8, 6, 4),
  # Adjusting using lower \%1RM (progression_perc_drop method used)
  adjustment = c(0, 0, 0, -0.1, -0.1, -0.1),
  vertical_planning = vertical_linear,
  vertical_planning_control = list(reps_change = c(0, -2, -4)),
  progression_table = progression_perc_drop,
  progression_table_control = list(volume = "extensive")
)

# Adjusted using RIR inc
# This time we adjust first wave as well, first two sets easier
scheme_wave(
  reps = c(8, 6, 4, 8, 6, 4),
  # Adjusting using lower \%1RM (RIR Increment method used)
  adjustment = c(4, 2, 0, 6, 4, 2),
  vertical_planning = vertical_linear,
  vertical_planning_control = list(reps_change = c(0, -2, -4)),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

# Plateau set and rep schemes
--------------------------
  scheme_plateau()

scheme_plateau(
  reps = c(3, 3, 3),
  progression_table_control = list(type = "ballistic")
)

# Step set and rep schemes
--------------------------
  scheme_step()

scheme_step(
  reps = c(2, 2, 2),
  adjustment = c(-0.1, -0.05, 0),
  vertical_planning = vertical_linear_reverse,
  progression_table_control = list(type = "ballistic")
)

# Reverse Step set and rep schemes
--------------------------
  scheme_step_reverse()

# Descending Wave set and rep schemes
--------------------------
  scheme_wave_descending()

# Light-Heavy set and rep schemes
--------------------------
  scheme_light_heavy()

# Pyramid set and rep schemes
--------------------------
  scheme_pyramid()

# Reverse Pyramid set and rep schemes
--------------------------
  scheme_pyramid_reverse()

# Rep Accumulation set and rep schemes
--------------------------
  scheme_rep_acc()
}
